/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DataDownload;
import com.google.schemaorg.core.Distance;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.MediaObjectImpl;
import com.google.schemaorg.core.NewsArticle;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DataDownloadImpl
extends MediaObjectImpl
implements DataDownload {
    private static final ImmutableSet<String> PROPERTY_SET = DataDownloadImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedArticle");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/bitrate");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contentSize");
        builder.add((Object)"http://schema.org/contentUrl");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/duration");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/embedUrl");
        builder.add((Object)"http://schema.org/encodesCreativeWork");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodingFormat");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/expires");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/height");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/playerType");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/productionCompany");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/regionsAllowed");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/requiresSubscription");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/uploadDate");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/width");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DataDownloadImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DataDownload";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DataDownload.Builder>
    implements DataDownload.Builder {
        BuilderImpl() {
        }

        @Override
        public DataDownload.Builder addAbout(Thing value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public DataDownload.Builder addAbout(Thing.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public DataDownload.Builder addAbout(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAccessibilityAPI(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public DataDownload.Builder addAccessibilityAPI(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAccessibilityControl(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public DataDownload.Builder addAccessibilityControl(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAccessibilityFeature(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public DataDownload.Builder addAccessibilityFeature(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAccessibilityHazard(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public DataDownload.Builder addAccessibilityHazard(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAccountablePerson(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public DataDownload.Builder addAccountablePerson(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public DataDownload.Builder addAccountablePerson(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAdditionalType(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DataDownload.Builder addAdditionalType(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAggregateRating(AggregateRating value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public DataDownload.Builder addAggregateRating(AggregateRating.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public DataDownload.Builder addAggregateRating(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAlternateName(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DataDownload.Builder addAlternateName(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAlternativeHeadline(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public DataDownload.Builder addAlternativeHeadline(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAssociatedArticle(NewsArticle value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/associatedArticle", value);
        }

        @Override
        public DataDownload.Builder addAssociatedArticle(NewsArticle.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/associatedArticle", value.build());
        }

        @Override
        public DataDownload.Builder addAssociatedArticle(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/associatedArticle", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAssociatedMedia(MediaObject value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public DataDownload.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public DataDownload.Builder addAssociatedMedia(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAudience(Audience value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public DataDownload.Builder addAudience(Audience.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public DataDownload.Builder addAudience(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAudio(AudioObject value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public DataDownload.Builder addAudio(AudioObject.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public DataDownload.Builder addAudio(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAuthor(Organization value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public DataDownload.Builder addAuthor(Organization.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public DataDownload.Builder addAuthor(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public DataDownload.Builder addAuthor(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public DataDownload.Builder addAuthor(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAward(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public DataDownload.Builder addAward(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public DataDownload.Builder addAwards(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public DataDownload.Builder addAwards(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public DataDownload.Builder addBitrate(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/bitrate", value);
        }

        @Override
        public DataDownload.Builder addBitrate(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/bitrate", Text.of(value));
        }

        @Override
        public DataDownload.Builder addCharacter(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public DataDownload.Builder addCharacter(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public DataDownload.Builder addCharacter(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public DataDownload.Builder addCitation(CreativeWork value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public DataDownload.Builder addCitation(CreativeWork.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public DataDownload.Builder addCitation(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public DataDownload.Builder addCitation(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public DataDownload.Builder addComment(Comment value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public DataDownload.Builder addComment(Comment.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public DataDownload.Builder addComment(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public DataDownload.Builder addCommentCount(Integer value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public DataDownload.Builder addCommentCount(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public DataDownload.Builder addContentLocation(Place value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public DataDownload.Builder addContentLocation(Place.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public DataDownload.Builder addContentLocation(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public DataDownload.Builder addContentRating(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public DataDownload.Builder addContentRating(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public DataDownload.Builder addContentSize(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contentSize", value);
        }

        @Override
        public DataDownload.Builder addContentSize(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contentSize", Text.of(value));
        }

        @Override
        public DataDownload.Builder addContentUrl(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contentUrl", value);
        }

        @Override
        public DataDownload.Builder addContentUrl(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contentUrl", Text.of(value));
        }

        @Override
        public DataDownload.Builder addContributor(Organization value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public DataDownload.Builder addContributor(Organization.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public DataDownload.Builder addContributor(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public DataDownload.Builder addContributor(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public DataDownload.Builder addContributor(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public DataDownload.Builder addCopyrightHolder(Organization value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public DataDownload.Builder addCopyrightHolder(Organization.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public DataDownload.Builder addCopyrightHolder(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public DataDownload.Builder addCopyrightHolder(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public DataDownload.Builder addCopyrightHolder(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public DataDownload.Builder addCopyrightYear(Number value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public DataDownload.Builder addCopyrightYear(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public DataDownload.Builder addCreator(Organization value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public DataDownload.Builder addCreator(Organization.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public DataDownload.Builder addCreator(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public DataDownload.Builder addCreator(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public DataDownload.Builder addCreator(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public DataDownload.Builder addDateCreated(Date value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public DataDownload.Builder addDateCreated(DateTime value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public DataDownload.Builder addDateCreated(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public DataDownload.Builder addDateModified(Date value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public DataDownload.Builder addDateModified(DateTime value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public DataDownload.Builder addDateModified(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public DataDownload.Builder addDatePublished(Date value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public DataDownload.Builder addDatePublished(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public DataDownload.Builder addDescription(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DataDownload.Builder addDescription(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DataDownload.Builder addDiscussionUrl(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public DataDownload.Builder addDiscussionUrl(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public DataDownload.Builder addDuration(Duration value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/duration", value);
        }

        @Override
        public DataDownload.Builder addDuration(Duration.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/duration", value.build());
        }

        @Override
        public DataDownload.Builder addDuration(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/duration", Text.of(value));
        }

        @Override
        public DataDownload.Builder addEditor(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public DataDownload.Builder addEditor(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public DataDownload.Builder addEditor(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public DataDownload.Builder addEducationalAlignment(AlignmentObject value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public DataDownload.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public DataDownload.Builder addEducationalAlignment(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public DataDownload.Builder addEducationalUse(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public DataDownload.Builder addEducationalUse(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public DataDownload.Builder addEmbedUrl(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/embedUrl", value);
        }

        @Override
        public DataDownload.Builder addEmbedUrl(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/embedUrl", Text.of(value));
        }

        @Override
        public DataDownload.Builder addEncodesCreativeWork(CreativeWork value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encodesCreativeWork", value);
        }

        @Override
        public DataDownload.Builder addEncodesCreativeWork(CreativeWork.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encodesCreativeWork", value.build());
        }

        @Override
        public DataDownload.Builder addEncodesCreativeWork(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encodesCreativeWork", Text.of(value));
        }

        @Override
        public DataDownload.Builder addEncoding(MediaObject value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public DataDownload.Builder addEncoding(MediaObject.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public DataDownload.Builder addEncoding(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public DataDownload.Builder addEncodingFormat(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encodingFormat", value);
        }

        @Override
        public DataDownload.Builder addEncodingFormat(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encodingFormat", Text.of(value));
        }

        @Override
        public DataDownload.Builder addEncodings(MediaObject value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public DataDownload.Builder addEncodings(MediaObject.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public DataDownload.Builder addEncodings(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public DataDownload.Builder addExampleOfWork(CreativeWork value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public DataDownload.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public DataDownload.Builder addExampleOfWork(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public DataDownload.Builder addExpires(Date value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/expires", value);
        }

        @Override
        public DataDownload.Builder addExpires(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/expires", Text.of(value));
        }

        @Override
        public DataDownload.Builder addFileFormat(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public DataDownload.Builder addFileFormat(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public DataDownload.Builder addGenre(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public DataDownload.Builder addGenre(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public DataDownload.Builder addGenre(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public DataDownload.Builder addHasPart(CreativeWork value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public DataDownload.Builder addHasPart(CreativeWork.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public DataDownload.Builder addHasPart(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public DataDownload.Builder addHeadline(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public DataDownload.Builder addHeadline(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public DataDownload.Builder addHeight(Distance value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/height", value);
        }

        @Override
        public DataDownload.Builder addHeight(Distance.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/height", value.build());
        }

        @Override
        public DataDownload.Builder addHeight(QuantitativeValue value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/height", value);
        }

        @Override
        public DataDownload.Builder addHeight(QuantitativeValue.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/height", value.build());
        }

        @Override
        public DataDownload.Builder addHeight(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/height", Text.of(value));
        }

        @Override
        public DataDownload.Builder addImage(ImageObject value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DataDownload.Builder addImage(ImageObject.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DataDownload.Builder addImage(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DataDownload.Builder addImage(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DataDownload.Builder addInLanguage(Language value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public DataDownload.Builder addInLanguage(Language.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public DataDownload.Builder addInLanguage(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public DataDownload.Builder addInLanguage(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public DataDownload.Builder addInteractionStatistic(InteractionCounter value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public DataDownload.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public DataDownload.Builder addInteractionStatistic(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public DataDownload.Builder addInteractivityType(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public DataDownload.Builder addInteractivityType(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public DataDownload.Builder addIsBasedOnUrl(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public DataDownload.Builder addIsBasedOnUrl(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public DataDownload.Builder addIsFamilyFriendly(Boolean value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public DataDownload.Builder addIsFamilyFriendly(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public DataDownload.Builder addIsPartOf(CreativeWork value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public DataDownload.Builder addIsPartOf(CreativeWork.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public DataDownload.Builder addIsPartOf(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public DataDownload.Builder addKeywords(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public DataDownload.Builder addKeywords(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public DataDownload.Builder addLearningResourceType(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public DataDownload.Builder addLearningResourceType(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public DataDownload.Builder addLicense(CreativeWork value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public DataDownload.Builder addLicense(CreativeWork.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public DataDownload.Builder addLicense(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public DataDownload.Builder addLicense(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public DataDownload.Builder addLocationCreated(Place value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public DataDownload.Builder addLocationCreated(Place.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public DataDownload.Builder addLocationCreated(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public DataDownload.Builder addMainEntity(Thing value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public DataDownload.Builder addMainEntity(Thing.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public DataDownload.Builder addMainEntity(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public DataDownload.Builder addMainEntityOfPage(CreativeWork value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DataDownload.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DataDownload.Builder addMainEntityOfPage(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DataDownload.Builder addMainEntityOfPage(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DataDownload.Builder addMentions(Thing value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public DataDownload.Builder addMentions(Thing.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public DataDownload.Builder addMentions(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public DataDownload.Builder addName(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DataDownload.Builder addName(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DataDownload.Builder addOffers(Offer value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public DataDownload.Builder addOffers(Offer.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public DataDownload.Builder addOffers(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public DataDownload.Builder addPlayerType(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/playerType", value);
        }

        @Override
        public DataDownload.Builder addPlayerType(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/playerType", Text.of(value));
        }

        @Override
        public DataDownload.Builder addPosition(Integer value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public DataDownload.Builder addPosition(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public DataDownload.Builder addPosition(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public DataDownload.Builder addPotentialAction(Action value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DataDownload.Builder addPotentialAction(Action.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DataDownload.Builder addPotentialAction(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DataDownload.Builder addProducer(Organization value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public DataDownload.Builder addProducer(Organization.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public DataDownload.Builder addProducer(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public DataDownload.Builder addProducer(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public DataDownload.Builder addProducer(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public DataDownload.Builder addProductionCompany(Organization value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/productionCompany", value);
        }

        @Override
        public DataDownload.Builder addProductionCompany(Organization.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/productionCompany", value.build());
        }

        @Override
        public DataDownload.Builder addProductionCompany(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/productionCompany", Text.of(value));
        }

        @Override
        public DataDownload.Builder addProvider(Organization value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public DataDownload.Builder addProvider(Organization.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public DataDownload.Builder addProvider(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public DataDownload.Builder addProvider(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public DataDownload.Builder addProvider(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public DataDownload.Builder addPublication(PublicationEvent value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public DataDownload.Builder addPublication(PublicationEvent.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public DataDownload.Builder addPublication(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public DataDownload.Builder addPublisher(Organization value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public DataDownload.Builder addPublisher(Organization.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public DataDownload.Builder addPublisher(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public DataDownload.Builder addPublisher(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public DataDownload.Builder addPublisher(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public DataDownload.Builder addPublishingPrinciples(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public DataDownload.Builder addPublishingPrinciples(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public DataDownload.Builder addRecordedAt(Event value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public DataDownload.Builder addRecordedAt(Event.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public DataDownload.Builder addRecordedAt(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public DataDownload.Builder addRegionsAllowed(Place value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/regionsAllowed", value);
        }

        @Override
        public DataDownload.Builder addRegionsAllowed(Place.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/regionsAllowed", value.build());
        }

        @Override
        public DataDownload.Builder addRegionsAllowed(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/regionsAllowed", Text.of(value));
        }

        @Override
        public DataDownload.Builder addReleasedEvent(PublicationEvent value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public DataDownload.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public DataDownload.Builder addReleasedEvent(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public DataDownload.Builder addRequiresSubscription(Boolean value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/requiresSubscription", value);
        }

        @Override
        public DataDownload.Builder addRequiresSubscription(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/requiresSubscription", Text.of(value));
        }

        @Override
        public DataDownload.Builder addReview(Review value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public DataDownload.Builder addReview(Review.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public DataDownload.Builder addReview(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public DataDownload.Builder addReviews(Review value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public DataDownload.Builder addReviews(Review.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public DataDownload.Builder addReviews(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public DataDownload.Builder addSameAs(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DataDownload.Builder addSameAs(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DataDownload.Builder addSchemaVersion(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public DataDownload.Builder addSchemaVersion(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public DataDownload.Builder addSchemaVersion(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public DataDownload.Builder addSourceOrganization(Organization value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public DataDownload.Builder addSourceOrganization(Organization.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public DataDownload.Builder addSourceOrganization(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public DataDownload.Builder addText(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public DataDownload.Builder addText(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public DataDownload.Builder addThumbnailUrl(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public DataDownload.Builder addThumbnailUrl(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public DataDownload.Builder addTimeRequired(Duration value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public DataDownload.Builder addTimeRequired(Duration.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public DataDownload.Builder addTimeRequired(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public DataDownload.Builder addTranslator(Organization value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public DataDownload.Builder addTranslator(Organization.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public DataDownload.Builder addTranslator(Person value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public DataDownload.Builder addTranslator(Person.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public DataDownload.Builder addTranslator(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public DataDownload.Builder addTypicalAgeRange(Text value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public DataDownload.Builder addTypicalAgeRange(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public DataDownload.Builder addUploadDate(Date value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/uploadDate", value);
        }

        @Override
        public DataDownload.Builder addUploadDate(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/uploadDate", Text.of(value));
        }

        @Override
        public DataDownload.Builder addUrl(URL value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DataDownload.Builder addUrl(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DataDownload.Builder addVersion(Number value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public DataDownload.Builder addVersion(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public DataDownload.Builder addVideo(VideoObject value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public DataDownload.Builder addVideo(VideoObject.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public DataDownload.Builder addVideo(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public DataDownload.Builder addWidth(Distance value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/width", value);
        }

        @Override
        public DataDownload.Builder addWidth(Distance.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/width", value.build());
        }

        @Override
        public DataDownload.Builder addWidth(QuantitativeValue value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/width", value);
        }

        @Override
        public DataDownload.Builder addWidth(QuantitativeValue.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/width", value.build());
        }

        @Override
        public DataDownload.Builder addWidth(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/width", Text.of(value));
        }

        @Override
        public DataDownload.Builder addWorkExample(CreativeWork value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public DataDownload.Builder addWorkExample(CreativeWork.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public DataDownload.Builder addWorkExample(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public DataDownload.Builder addDetailedDescription(Article value) {
            return (DataDownload.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DataDownload.Builder addDetailedDescription(Article.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DataDownload.Builder addDetailedDescription(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DataDownload.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DataDownload.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DataDownload.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DataDownload.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DataDownload.Builder addPopularityScore(String value) {
            return (DataDownload.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DataDownload build() {
            return new DataDownloadImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

