/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DrugCost;
import com.google.schemaorg.core.DrugCostCategory;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIntangibleImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DrugCostImpl
extends MedicalIntangibleImpl
implements DrugCost {
    private static final ImmutableSet<String> PROPERTY_SET = DrugCostImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/applicableLocation");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/costCategory");
        builder.add((Object)"http://schema.org/costCurrency");
        builder.add((Object)"http://schema.org/costOrigin");
        builder.add((Object)"http://schema.org/costPerUnit");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/drugUnit");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DrugCostImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DrugCost";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getApplicableLocationList() {
        return this.getProperty("http://schema.org/applicableLocation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCostCategoryList() {
        return this.getProperty("http://schema.org/costCategory");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCostCurrencyList() {
        return this.getProperty("http://schema.org/costCurrency");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCostOriginList() {
        return this.getProperty("http://schema.org/costOrigin");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCostPerUnitList() {
        return this.getProperty("http://schema.org/costPerUnit");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDrugUnitList() {
        return this.getProperty("http://schema.org/drugUnit");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DrugCost.Builder>
    implements DrugCost.Builder {
        BuilderImpl() {
        }

        @Override
        public DrugCost.Builder addAdditionalType(URL value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DrugCost.Builder addAdditionalType(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DrugCost.Builder addAlternateName(Text value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DrugCost.Builder addAlternateName(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DrugCost.Builder addApplicableLocation(AdministrativeArea value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/applicableLocation", value);
        }

        @Override
        public DrugCost.Builder addApplicableLocation(AdministrativeArea.Builder value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/applicableLocation", value.build());
        }

        @Override
        public DrugCost.Builder addApplicableLocation(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/applicableLocation", Text.of(value));
        }

        @Override
        public DrugCost.Builder addCode(MedicalCode value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public DrugCost.Builder addCode(MedicalCode.Builder value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public DrugCost.Builder addCode(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public DrugCost.Builder addCostCategory(DrugCostCategory value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/costCategory", value);
        }

        @Override
        public DrugCost.Builder addCostCategory(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/costCategory", Text.of(value));
        }

        @Override
        public DrugCost.Builder addCostCurrency(Text value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/costCurrency", value);
        }

        @Override
        public DrugCost.Builder addCostCurrency(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/costCurrency", Text.of(value));
        }

        @Override
        public DrugCost.Builder addCostOrigin(Text value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/costOrigin", value);
        }

        @Override
        public DrugCost.Builder addCostOrigin(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/costOrigin", Text.of(value));
        }

        @Override
        public DrugCost.Builder addCostPerUnit(Number value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/costPerUnit", value);
        }

        @Override
        public DrugCost.Builder addCostPerUnit(Text value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/costPerUnit", value);
        }

        @Override
        public DrugCost.Builder addCostPerUnit(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/costPerUnit", Text.of(value));
        }

        @Override
        public DrugCost.Builder addDescription(Text value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DrugCost.Builder addDescription(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DrugCost.Builder addDrugUnit(Text value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/drugUnit", value);
        }

        @Override
        public DrugCost.Builder addDrugUnit(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/drugUnit", Text.of(value));
        }

        @Override
        public DrugCost.Builder addGuideline(MedicalGuideline value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public DrugCost.Builder addGuideline(MedicalGuideline.Builder value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public DrugCost.Builder addGuideline(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public DrugCost.Builder addImage(ImageObject value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DrugCost.Builder addImage(ImageObject.Builder value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DrugCost.Builder addImage(URL value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DrugCost.Builder addImage(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DrugCost.Builder addMainEntityOfPage(CreativeWork value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DrugCost.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DrugCost.Builder addMainEntityOfPage(URL value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DrugCost.Builder addMainEntityOfPage(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DrugCost.Builder addMedicineSystem(MedicineSystem value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public DrugCost.Builder addMedicineSystem(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public DrugCost.Builder addName(Text value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DrugCost.Builder addName(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DrugCost.Builder addPotentialAction(Action value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DrugCost.Builder addPotentialAction(Action.Builder value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DrugCost.Builder addPotentialAction(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DrugCost.Builder addRecognizingAuthority(Organization value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public DrugCost.Builder addRecognizingAuthority(Organization.Builder value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public DrugCost.Builder addRecognizingAuthority(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public DrugCost.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public DrugCost.Builder addRelevantSpecialty(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public DrugCost.Builder addSameAs(URL value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DrugCost.Builder addSameAs(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DrugCost.Builder addStudy(MedicalStudy value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public DrugCost.Builder addStudy(MedicalStudy.Builder value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public DrugCost.Builder addStudy(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public DrugCost.Builder addUrl(URL value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DrugCost.Builder addUrl(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DrugCost.Builder addDetailedDescription(Article value) {
            return (DrugCost.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DrugCost.Builder addDetailedDescription(Article.Builder value) {
            return (DrugCost.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DrugCost.Builder addDetailedDescription(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DrugCost.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DrugCost.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DrugCost.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DrugCost.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DrugCost.Builder addPopularityScore(String value) {
            return (DrugCost.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DrugCost build() {
            return new DrugCostImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

