/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.AudienceImpl;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.EducationalAudience;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class EducationalAudienceImpl
extends AudienceImpl
implements EducationalAudience {
    private static final ImmutableSet<String> PROPERTY_SET = EducationalAudienceImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/audienceType");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/educationalRole");
        builder.add((Object)"http://schema.org/geographicArea");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public EducationalAudienceImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/EducationalAudience";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getEducationalRoleList() {
        return this.getProperty("http://schema.org/educationalRole");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<EducationalAudience.Builder>
    implements EducationalAudience.Builder {
        BuilderImpl() {
        }

        @Override
        public EducationalAudience.Builder addAdditionalType(URL value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public EducationalAudience.Builder addAdditionalType(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addAlternateName(Text value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public EducationalAudience.Builder addAlternateName(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addAudienceType(Text value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/audienceType", value);
        }

        @Override
        public EducationalAudience.Builder addAudienceType(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/audienceType", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addDescription(Text value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public EducationalAudience.Builder addDescription(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addEducationalRole(Text value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/educationalRole", value);
        }

        @Override
        public EducationalAudience.Builder addEducationalRole(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/educationalRole", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addGeographicArea(AdministrativeArea value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/geographicArea", value);
        }

        @Override
        public EducationalAudience.Builder addGeographicArea(AdministrativeArea.Builder value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/geographicArea", value.build());
        }

        @Override
        public EducationalAudience.Builder addGeographicArea(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/geographicArea", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addImage(ImageObject value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public EducationalAudience.Builder addImage(ImageObject.Builder value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public EducationalAudience.Builder addImage(URL value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public EducationalAudience.Builder addImage(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addMainEntityOfPage(CreativeWork value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public EducationalAudience.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public EducationalAudience.Builder addMainEntityOfPage(URL value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public EducationalAudience.Builder addMainEntityOfPage(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addName(Text value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public EducationalAudience.Builder addName(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addPotentialAction(Action value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public EducationalAudience.Builder addPotentialAction(Action.Builder value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public EducationalAudience.Builder addPotentialAction(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addSameAs(URL value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public EducationalAudience.Builder addSameAs(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addUrl(URL value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public EducationalAudience.Builder addUrl(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addDetailedDescription(Article value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public EducationalAudience.Builder addDetailedDescription(Article.Builder value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public EducationalAudience.Builder addDetailedDescription(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public EducationalAudience.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public EducationalAudience.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public EducationalAudience.Builder addPopularityScore(String value) {
            return (EducationalAudience.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public EducationalAudience build() {
            return new EducationalAudienceImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

