/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Intangible;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.ThingImpl;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class IntangibleImpl
extends ThingImpl
implements Intangible {
    private static final ImmutableSet<String> PROPERTY_SET = IntangibleImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public IntangibleImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Intangible";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Intangible.Builder>
    implements Intangible.Builder {
        BuilderImpl() {
        }

        @Override
        public Intangible.Builder addAdditionalType(URL value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Intangible.Builder addAdditionalType(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Intangible.Builder addAlternateName(Text value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Intangible.Builder addAlternateName(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Intangible.Builder addDescription(Text value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Intangible.Builder addDescription(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Intangible.Builder addImage(ImageObject value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Intangible.Builder addImage(ImageObject.Builder value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Intangible.Builder addImage(URL value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Intangible.Builder addImage(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Intangible.Builder addMainEntityOfPage(CreativeWork value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Intangible.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Intangible.Builder addMainEntityOfPage(URL value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Intangible.Builder addMainEntityOfPage(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Intangible.Builder addName(Text value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Intangible.Builder addName(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Intangible.Builder addPotentialAction(Action value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Intangible.Builder addPotentialAction(Action.Builder value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Intangible.Builder addPotentialAction(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Intangible.Builder addSameAs(URL value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Intangible.Builder addSameAs(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Intangible.Builder addUrl(URL value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Intangible.Builder addUrl(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Intangible.Builder addDetailedDescription(Article value) {
            return (Intangible.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Intangible.Builder addDetailedDescription(Article.Builder value) {
            return (Intangible.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Intangible.Builder addDetailedDescription(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Intangible.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Intangible.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Intangible.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Intangible.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Intangible.Builder addPopularityScore(String value) {
            return (Intangible.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Intangible build() {
            return new IntangibleImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

