/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCause;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalCauseImpl
extends MedicalEntityImpl
implements MedicalCause {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalCauseImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/causeOf");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalCauseImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalCause";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCauseOfList() {
        return this.getProperty("http://schema.org/causeOf");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalCause.Builder>
    implements MedicalCause.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalCause.Builder addAdditionalType(URL value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalCause.Builder addAdditionalType(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addAlternateName(Text value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalCause.Builder addAlternateName(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addCauseOf(MedicalEntity value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/causeOf", value);
        }

        @Override
        public MedicalCause.Builder addCauseOf(MedicalEntity.Builder value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/causeOf", value.build());
        }

        @Override
        public MedicalCause.Builder addCauseOf(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/causeOf", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addCode(MedicalCode value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalCause.Builder addCode(MedicalCode.Builder value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalCause.Builder addCode(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addDescription(Text value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalCause.Builder addDescription(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addGuideline(MedicalGuideline value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalCause.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalCause.Builder addGuideline(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addImage(ImageObject value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalCause.Builder addImage(ImageObject.Builder value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalCause.Builder addImage(URL value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalCause.Builder addImage(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalCause.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalCause.Builder addMainEntityOfPage(URL value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalCause.Builder addMainEntityOfPage(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalCause.Builder addMedicineSystem(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addName(Text value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalCause.Builder addName(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addPotentialAction(Action value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalCause.Builder addPotentialAction(Action.Builder value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalCause.Builder addPotentialAction(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addRecognizingAuthority(Organization value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalCause.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalCause.Builder addRecognizingAuthority(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalCause.Builder addRelevantSpecialty(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addSameAs(URL value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalCause.Builder addSameAs(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addStudy(MedicalStudy value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalCause.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalCause.Builder addStudy(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addUrl(URL value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalCause.Builder addUrl(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addDetailedDescription(Article value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalCause.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalCause.Builder addDetailedDescription(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalCause.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalCause.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalCause.Builder addPopularityScore(String value) {
            return (MedicalCause.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalCause build() {
            return new MedicalCauseImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

