/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.ThingImpl;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalEntityImpl
extends ThingImpl
implements MedicalEntity {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalEntityImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalEntityImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalEntity";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCodeList() {
        return this.getProperty("http://schema.org/code");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGuidelineList() {
        return this.getProperty("http://schema.org/guideline");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMedicineSystemList() {
        return this.getProperty("http://schema.org/medicineSystem");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecognizingAuthorityList() {
        return this.getProperty("http://schema.org/recognizingAuthority");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRelevantSpecialtyList() {
        return this.getProperty("http://schema.org/relevantSpecialty");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStudyList() {
        return this.getProperty("http://schema.org/study");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalEntity.Builder>
    implements MedicalEntity.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalEntity.Builder addAdditionalType(URL value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalEntity.Builder addAdditionalType(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addAlternateName(Text value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalEntity.Builder addAlternateName(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addCode(MedicalCode value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalEntity.Builder addCode(MedicalCode.Builder value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalEntity.Builder addCode(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addDescription(Text value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalEntity.Builder addDescription(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addGuideline(MedicalGuideline value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalEntity.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalEntity.Builder addGuideline(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addImage(ImageObject value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalEntity.Builder addImage(ImageObject.Builder value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalEntity.Builder addImage(URL value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalEntity.Builder addImage(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalEntity.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalEntity.Builder addMainEntityOfPage(URL value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalEntity.Builder addMainEntityOfPage(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalEntity.Builder addMedicineSystem(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addName(Text value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalEntity.Builder addName(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addPotentialAction(Action value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalEntity.Builder addPotentialAction(Action.Builder value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalEntity.Builder addPotentialAction(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addRecognizingAuthority(Organization value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalEntity.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalEntity.Builder addRecognizingAuthority(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalEntity.Builder addRelevantSpecialty(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addSameAs(URL value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalEntity.Builder addSameAs(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addStudy(MedicalStudy value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalEntity.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalEntity.Builder addStudy(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addUrl(URL value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalEntity.Builder addUrl(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addDetailedDescription(Article value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalEntity.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalEntity.Builder addDetailedDescription(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalEntity.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalEntity.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalEntity.Builder addPopularityScore(String value) {
            return (MedicalEntity.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalEntity build() {
            return new MedicalEntityImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

