/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalRiskEstimator;
import com.google.schemaorg.core.MedicalRiskFactor;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalRiskEstimatorImpl
extends MedicalEntityImpl
implements MedicalRiskEstimator {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalRiskEstimatorImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/estimatesRiskOf");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/includedRiskFactor");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalRiskEstimatorImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalRiskEstimator";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getEstimatesRiskOfList() {
        return this.getProperty("http://schema.org/estimatesRiskOf");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIncludedRiskFactorList() {
        return this.getProperty("http://schema.org/includedRiskFactor");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalRiskEstimator.Builder>
    implements MedicalRiskEstimator.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalRiskEstimator.Builder addAdditionalType(URL value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addAdditionalType(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addAlternateName(Text value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addAlternateName(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addCode(MedicalCode value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addCode(MedicalCode.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addCode(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addDescription(Text value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addDescription(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addEstimatesRiskOf(MedicalEntity value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/estimatesRiskOf", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addEstimatesRiskOf(MedicalEntity.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/estimatesRiskOf", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addEstimatesRiskOf(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/estimatesRiskOf", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addGuideline(MedicalGuideline value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addGuideline(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addImage(ImageObject value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addImage(ImageObject.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addImage(URL value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addImage(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addIncludedRiskFactor(MedicalRiskFactor value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/includedRiskFactor", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addIncludedRiskFactor(MedicalRiskFactor.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/includedRiskFactor", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addIncludedRiskFactor(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/includedRiskFactor", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addMainEntityOfPage(URL value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addMainEntityOfPage(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addMedicineSystem(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addName(Text value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addName(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addPotentialAction(Action value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addPotentialAction(Action.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addPotentialAction(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addRecognizingAuthority(Organization value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addRecognizingAuthority(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addRelevantSpecialty(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addSameAs(URL value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addSameAs(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addStudy(MedicalStudy value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addStudy(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addUrl(URL value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addUrl(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addDetailedDescription(Article value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addDetailedDescription(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalRiskEstimator.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalRiskEstimator.Builder addPopularityScore(String value) {
            return (MedicalRiskEstimator.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalRiskEstimator build() {
            return new MedicalRiskEstimatorImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

