/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCause;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSignOrSymptom;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalSignOrSymptomImpl
extends MedicalEntityImpl
implements MedicalSignOrSymptom {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalSignOrSymptomImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/cause");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/possibleTreatment");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalSignOrSymptomImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalSignOrSymptom";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCauseList() {
        return this.getProperty("http://schema.org/cause");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPossibleTreatmentList() {
        return this.getProperty("http://schema.org/possibleTreatment");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalSignOrSymptom.Builder>
    implements MedicalSignOrSymptom.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalSignOrSymptom.Builder addAdditionalType(URL value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addAdditionalType(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addAlternateName(Text value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addAlternateName(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addCause(MedicalCause value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/cause", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addCause(MedicalCause.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/cause", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addCause(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/cause", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addCode(MedicalCode value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addCode(MedicalCode.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addCode(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addDescription(Text value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addDescription(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addGuideline(MedicalGuideline value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addGuideline(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addImage(ImageObject value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addImage(ImageObject.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addImage(URL value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addImage(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addMainEntityOfPage(URL value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addMainEntityOfPage(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addMedicineSystem(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addName(Text value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addName(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addPossibleTreatment(MedicalTherapy value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/possibleTreatment", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addPossibleTreatment(MedicalTherapy.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/possibleTreatment", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addPossibleTreatment(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/possibleTreatment", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addPotentialAction(Action value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addPotentialAction(Action.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addPotentialAction(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addRecognizingAuthority(Organization value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addRecognizingAuthority(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addRelevantSpecialty(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addSameAs(URL value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addSameAs(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addStudy(MedicalStudy value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addStudy(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addUrl(URL value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addUrl(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addDetailedDescription(Article value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addDetailedDescription(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalSignOrSymptom.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalSignOrSymptom.Builder addPopularityScore(String value) {
            return (MedicalSignOrSymptom.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalSignOrSymptom build() {
            return new MedicalSignOrSymptomImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

