/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalStudyStatus;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalStudyImpl
extends MedicalEntityImpl
implements MedicalStudy {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalStudyImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/outcome");
        builder.add((Object)"http://schema.org/population");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/sponsor");
        builder.add((Object)"http://schema.org/status");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/studyLocation");
        builder.add((Object)"http://schema.org/studySubject");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalStudyImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalStudy";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getOutcomeList() {
        return this.getProperty("http://schema.org/outcome");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPopulationList() {
        return this.getProperty("http://schema.org/population");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSponsorList() {
        return this.getProperty("http://schema.org/sponsor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStatusList() {
        return this.getProperty("http://schema.org/status");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStudyLocationList() {
        return this.getProperty("http://schema.org/studyLocation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStudySubjectList() {
        return this.getProperty("http://schema.org/studySubject");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalStudy.Builder>
    implements MedicalStudy.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalStudy.Builder addAdditionalType(URL value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalStudy.Builder addAdditionalType(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addAlternateName(Text value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalStudy.Builder addAlternateName(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addCode(MedicalCode value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalStudy.Builder addCode(MedicalCode.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalStudy.Builder addCode(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addDescription(Text value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalStudy.Builder addDescription(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addGuideline(MedicalGuideline value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalStudy.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalStudy.Builder addGuideline(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addImage(ImageObject value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalStudy.Builder addImage(ImageObject.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalStudy.Builder addImage(URL value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalStudy.Builder addImage(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalStudy.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalStudy.Builder addMainEntityOfPage(URL value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalStudy.Builder addMainEntityOfPage(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalStudy.Builder addMedicineSystem(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addName(Text value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalStudy.Builder addName(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addOutcome(Text value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/outcome", value);
        }

        @Override
        public MedicalStudy.Builder addOutcome(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/outcome", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addPopulation(Text value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/population", value);
        }

        @Override
        public MedicalStudy.Builder addPopulation(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/population", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addPotentialAction(Action value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalStudy.Builder addPotentialAction(Action.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalStudy.Builder addPotentialAction(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addRecognizingAuthority(Organization value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalStudy.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalStudy.Builder addRecognizingAuthority(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalStudy.Builder addRelevantSpecialty(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addSameAs(URL value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalStudy.Builder addSameAs(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addSponsor(Organization value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/sponsor", value);
        }

        @Override
        public MedicalStudy.Builder addSponsor(Organization.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/sponsor", value.build());
        }

        @Override
        public MedicalStudy.Builder addSponsor(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/sponsor", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addStatus(MedicalStudyStatus value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/status", value);
        }

        @Override
        public MedicalStudy.Builder addStatus(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/status", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addStudy(MedicalStudy value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalStudy.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalStudy.Builder addStudy(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addStudyLocation(AdministrativeArea value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/studyLocation", value);
        }

        @Override
        public MedicalStudy.Builder addStudyLocation(AdministrativeArea.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/studyLocation", value.build());
        }

        @Override
        public MedicalStudy.Builder addStudyLocation(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/studyLocation", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addStudySubject(MedicalEntity value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/studySubject", value);
        }

        @Override
        public MedicalStudy.Builder addStudySubject(MedicalEntity.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/studySubject", value.build());
        }

        @Override
        public MedicalStudy.Builder addStudySubject(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/studySubject", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addUrl(URL value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalStudy.Builder addUrl(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addDetailedDescription(Article value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalStudy.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalStudy.Builder addDetailedDescription(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalStudy.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalStudy.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalStudy.Builder addPopularityScore(String value) {
            return (MedicalStudy.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalStudy build() {
            return new MedicalStudyImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

