/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkSeriesImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.MovieSeries;
import com.google.schemaorg.core.MusicGroup;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MovieSeriesImpl
extends CreativeWorkSeriesImpl
implements MovieSeries {
    private static final ImmutableSet<String> PROPERTY_SET = MovieSeriesImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/actor");
        builder.add((Object)"http://schema.org/actors");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/director");
        builder.add((Object)"http://schema.org/directors");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/endDate");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/musicBy");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/productionCompany");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/startDate");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/trailer");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MovieSeriesImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MovieSeries";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getActorList() {
        return this.getProperty("http://schema.org/actor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getActorsList() {
        return this.getProperty("http://schema.org/actors");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDirectorList() {
        return this.getProperty("http://schema.org/director");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDirectorsList() {
        return this.getProperty("http://schema.org/directors");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMusicByList() {
        return this.getProperty("http://schema.org/musicBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProductionCompanyList() {
        return this.getProperty("http://schema.org/productionCompany");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTrailerList() {
        return this.getProperty("http://schema.org/trailer");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MovieSeries.Builder>
    implements MovieSeries.Builder {
        BuilderImpl() {
        }

        @Override
        public MovieSeries.Builder addAbout(Thing value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public MovieSeries.Builder addAbout(Thing.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public MovieSeries.Builder addAbout(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAccessibilityAPI(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public MovieSeries.Builder addAccessibilityAPI(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAccessibilityControl(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public MovieSeries.Builder addAccessibilityControl(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAccessibilityFeature(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public MovieSeries.Builder addAccessibilityFeature(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAccessibilityHazard(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public MovieSeries.Builder addAccessibilityHazard(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAccountablePerson(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public MovieSeries.Builder addAccountablePerson(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public MovieSeries.Builder addAccountablePerson(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addActor(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/actor", value);
        }

        @Override
        public MovieSeries.Builder addActor(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/actor", value.build());
        }

        @Override
        public MovieSeries.Builder addActor(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/actor", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addActors(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/actors", value);
        }

        @Override
        public MovieSeries.Builder addActors(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/actors", value.build());
        }

        @Override
        public MovieSeries.Builder addActors(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/actors", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAdditionalType(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MovieSeries.Builder addAdditionalType(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAggregateRating(AggregateRating value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public MovieSeries.Builder addAggregateRating(AggregateRating.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public MovieSeries.Builder addAggregateRating(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAlternateName(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MovieSeries.Builder addAlternateName(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAlternativeHeadline(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public MovieSeries.Builder addAlternativeHeadline(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAssociatedMedia(MediaObject value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public MovieSeries.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public MovieSeries.Builder addAssociatedMedia(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAudience(Audience value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public MovieSeries.Builder addAudience(Audience.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public MovieSeries.Builder addAudience(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAudio(AudioObject value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public MovieSeries.Builder addAudio(AudioObject.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public MovieSeries.Builder addAudio(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAuthor(Organization value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MovieSeries.Builder addAuthor(Organization.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MovieSeries.Builder addAuthor(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MovieSeries.Builder addAuthor(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MovieSeries.Builder addAuthor(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAward(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public MovieSeries.Builder addAward(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addAwards(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public MovieSeries.Builder addAwards(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addCharacter(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public MovieSeries.Builder addCharacter(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public MovieSeries.Builder addCharacter(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addCitation(CreativeWork value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MovieSeries.Builder addCitation(CreativeWork.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public MovieSeries.Builder addCitation(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MovieSeries.Builder addCitation(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addComment(Comment value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public MovieSeries.Builder addComment(Comment.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public MovieSeries.Builder addComment(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addCommentCount(Integer value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public MovieSeries.Builder addCommentCount(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addContentLocation(Place value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public MovieSeries.Builder addContentLocation(Place.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public MovieSeries.Builder addContentLocation(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addContentRating(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public MovieSeries.Builder addContentRating(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addContributor(Organization value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MovieSeries.Builder addContributor(Organization.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MovieSeries.Builder addContributor(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MovieSeries.Builder addContributor(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MovieSeries.Builder addContributor(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addCopyrightHolder(Organization value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MovieSeries.Builder addCopyrightHolder(Organization.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MovieSeries.Builder addCopyrightHolder(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MovieSeries.Builder addCopyrightHolder(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MovieSeries.Builder addCopyrightHolder(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addCopyrightYear(Number value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public MovieSeries.Builder addCopyrightYear(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addCreator(Organization value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MovieSeries.Builder addCreator(Organization.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MovieSeries.Builder addCreator(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MovieSeries.Builder addCreator(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MovieSeries.Builder addCreator(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addDateCreated(Date value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MovieSeries.Builder addDateCreated(DateTime value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MovieSeries.Builder addDateCreated(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addDateModified(Date value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MovieSeries.Builder addDateModified(DateTime value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MovieSeries.Builder addDateModified(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addDatePublished(Date value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public MovieSeries.Builder addDatePublished(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addDescription(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MovieSeries.Builder addDescription(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addDirector(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/director", value);
        }

        @Override
        public MovieSeries.Builder addDirector(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/director", value.build());
        }

        @Override
        public MovieSeries.Builder addDirector(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/director", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addDirectors(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/directors", value);
        }

        @Override
        public MovieSeries.Builder addDirectors(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/directors", value.build());
        }

        @Override
        public MovieSeries.Builder addDirectors(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/directors", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addDiscussionUrl(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public MovieSeries.Builder addDiscussionUrl(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addEditor(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public MovieSeries.Builder addEditor(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public MovieSeries.Builder addEditor(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addEducationalAlignment(AlignmentObject value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public MovieSeries.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public MovieSeries.Builder addEducationalAlignment(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addEducationalUse(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public MovieSeries.Builder addEducationalUse(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addEncoding(MediaObject value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public MovieSeries.Builder addEncoding(MediaObject.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public MovieSeries.Builder addEncoding(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addEncodings(MediaObject value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public MovieSeries.Builder addEncodings(MediaObject.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public MovieSeries.Builder addEncodings(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addEndDate(Date value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/endDate", value);
        }

        @Override
        public MovieSeries.Builder addEndDate(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/endDate", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addExampleOfWork(CreativeWork value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public MovieSeries.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public MovieSeries.Builder addExampleOfWork(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addFileFormat(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public MovieSeries.Builder addFileFormat(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addGenre(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MovieSeries.Builder addGenre(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MovieSeries.Builder addGenre(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addHasPart(CreativeWork value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public MovieSeries.Builder addHasPart(CreativeWork.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public MovieSeries.Builder addHasPart(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addHeadline(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public MovieSeries.Builder addHeadline(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addImage(ImageObject value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MovieSeries.Builder addImage(ImageObject.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MovieSeries.Builder addImage(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MovieSeries.Builder addImage(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addInLanguage(Language value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MovieSeries.Builder addInLanguage(Language.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public MovieSeries.Builder addInLanguage(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MovieSeries.Builder addInLanguage(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addInteractionStatistic(InteractionCounter value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public MovieSeries.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public MovieSeries.Builder addInteractionStatistic(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addInteractivityType(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public MovieSeries.Builder addInteractivityType(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addIsBasedOnUrl(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public MovieSeries.Builder addIsBasedOnUrl(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addIsFamilyFriendly(Boolean value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public MovieSeries.Builder addIsFamilyFriendly(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addIsPartOf(CreativeWork value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public MovieSeries.Builder addIsPartOf(CreativeWork.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public MovieSeries.Builder addIsPartOf(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addKeywords(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public MovieSeries.Builder addKeywords(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addLearningResourceType(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public MovieSeries.Builder addLearningResourceType(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addLicense(CreativeWork value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MovieSeries.Builder addLicense(CreativeWork.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public MovieSeries.Builder addLicense(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MovieSeries.Builder addLicense(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addLocationCreated(Place value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public MovieSeries.Builder addLocationCreated(Place.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public MovieSeries.Builder addLocationCreated(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addMainEntity(Thing value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public MovieSeries.Builder addMainEntity(Thing.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public MovieSeries.Builder addMainEntity(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addMainEntityOfPage(CreativeWork value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MovieSeries.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MovieSeries.Builder addMainEntityOfPage(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MovieSeries.Builder addMainEntityOfPage(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addMentions(Thing value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public MovieSeries.Builder addMentions(Thing.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public MovieSeries.Builder addMentions(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addMusicBy(MusicGroup value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/musicBy", value);
        }

        @Override
        public MovieSeries.Builder addMusicBy(MusicGroup.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/musicBy", value.build());
        }

        @Override
        public MovieSeries.Builder addMusicBy(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/musicBy", value);
        }

        @Override
        public MovieSeries.Builder addMusicBy(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/musicBy", value.build());
        }

        @Override
        public MovieSeries.Builder addMusicBy(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/musicBy", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addName(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MovieSeries.Builder addName(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addOffers(Offer value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public MovieSeries.Builder addOffers(Offer.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public MovieSeries.Builder addOffers(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addPosition(Integer value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MovieSeries.Builder addPosition(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MovieSeries.Builder addPosition(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addPotentialAction(Action value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MovieSeries.Builder addPotentialAction(Action.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MovieSeries.Builder addPotentialAction(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addProducer(Organization value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MovieSeries.Builder addProducer(Organization.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MovieSeries.Builder addProducer(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MovieSeries.Builder addProducer(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MovieSeries.Builder addProducer(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addProductionCompany(Organization value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/productionCompany", value);
        }

        @Override
        public MovieSeries.Builder addProductionCompany(Organization.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/productionCompany", value.build());
        }

        @Override
        public MovieSeries.Builder addProductionCompany(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/productionCompany", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addProvider(Organization value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MovieSeries.Builder addProvider(Organization.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MovieSeries.Builder addProvider(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MovieSeries.Builder addProvider(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MovieSeries.Builder addProvider(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addPublication(PublicationEvent value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public MovieSeries.Builder addPublication(PublicationEvent.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public MovieSeries.Builder addPublication(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addPublisher(Organization value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MovieSeries.Builder addPublisher(Organization.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MovieSeries.Builder addPublisher(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MovieSeries.Builder addPublisher(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MovieSeries.Builder addPublisher(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addPublishingPrinciples(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public MovieSeries.Builder addPublishingPrinciples(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addRecordedAt(Event value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public MovieSeries.Builder addRecordedAt(Event.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public MovieSeries.Builder addRecordedAt(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addReleasedEvent(PublicationEvent value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public MovieSeries.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public MovieSeries.Builder addReleasedEvent(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addReview(Review value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public MovieSeries.Builder addReview(Review.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public MovieSeries.Builder addReview(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addReviews(Review value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public MovieSeries.Builder addReviews(Review.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public MovieSeries.Builder addReviews(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addSameAs(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MovieSeries.Builder addSameAs(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addSchemaVersion(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MovieSeries.Builder addSchemaVersion(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MovieSeries.Builder addSchemaVersion(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addSourceOrganization(Organization value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public MovieSeries.Builder addSourceOrganization(Organization.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public MovieSeries.Builder addSourceOrganization(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addStartDate(Date value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/startDate", value);
        }

        @Override
        public MovieSeries.Builder addStartDate(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/startDate", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addText(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public MovieSeries.Builder addText(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addThumbnailUrl(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public MovieSeries.Builder addThumbnailUrl(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addTimeRequired(Duration value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public MovieSeries.Builder addTimeRequired(Duration.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public MovieSeries.Builder addTimeRequired(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addTrailer(VideoObject value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/trailer", value);
        }

        @Override
        public MovieSeries.Builder addTrailer(VideoObject.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/trailer", value.build());
        }

        @Override
        public MovieSeries.Builder addTrailer(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/trailer", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addTranslator(Organization value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MovieSeries.Builder addTranslator(Organization.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MovieSeries.Builder addTranslator(Person value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MovieSeries.Builder addTranslator(Person.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MovieSeries.Builder addTranslator(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addTypicalAgeRange(Text value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public MovieSeries.Builder addTypicalAgeRange(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addUrl(URL value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MovieSeries.Builder addUrl(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addVersion(Number value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public MovieSeries.Builder addVersion(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addVideo(VideoObject value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public MovieSeries.Builder addVideo(VideoObject.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public MovieSeries.Builder addVideo(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addWorkExample(CreativeWork value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public MovieSeries.Builder addWorkExample(CreativeWork.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public MovieSeries.Builder addWorkExample(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addDetailedDescription(Article value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MovieSeries.Builder addDetailedDescription(Article.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MovieSeries.Builder addDetailedDescription(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MovieSeries.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MovieSeries.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MovieSeries.Builder addPopularityScore(String value) {
            return (MovieSeries.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MovieSeries build() {
            return new MovieSeriesImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

