/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.ItemList;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.MusicAlbum;
import com.google.schemaorg.core.MusicAlbumProductionType;
import com.google.schemaorg.core.MusicAlbumReleaseType;
import com.google.schemaorg.core.MusicGroup;
import com.google.schemaorg.core.MusicPlaylistImpl;
import com.google.schemaorg.core.MusicRecording;
import com.google.schemaorg.core.MusicRelease;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MusicAlbumImpl
extends MusicPlaylistImpl
implements MusicAlbum {
    private static final ImmutableSet<String> PROPERTY_SET = MusicAlbumImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/albumProductionType");
        builder.add((Object)"http://schema.org/albumRelease");
        builder.add((Object)"http://schema.org/albumReleaseType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/byArtist");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/numTracks");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/track");
        builder.add((Object)"http://schema.org/tracks");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MusicAlbumImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MusicAlbum";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAlbumProductionTypeList() {
        return this.getProperty("http://schema.org/albumProductionType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAlbumReleaseList() {
        return this.getProperty("http://schema.org/albumRelease");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAlbumReleaseTypeList() {
        return this.getProperty("http://schema.org/albumReleaseType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getByArtistList() {
        return this.getProperty("http://schema.org/byArtist");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MusicAlbum.Builder>
    implements MusicAlbum.Builder {
        BuilderImpl() {
        }

        @Override
        public MusicAlbum.Builder addAbout(Thing value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public MusicAlbum.Builder addAbout(Thing.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public MusicAlbum.Builder addAbout(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAccessibilityAPI(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public MusicAlbum.Builder addAccessibilityAPI(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAccessibilityControl(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public MusicAlbum.Builder addAccessibilityControl(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAccessibilityFeature(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public MusicAlbum.Builder addAccessibilityFeature(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAccessibilityHazard(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public MusicAlbum.Builder addAccessibilityHazard(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAccountablePerson(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public MusicAlbum.Builder addAccountablePerson(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public MusicAlbum.Builder addAccountablePerson(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAdditionalType(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MusicAlbum.Builder addAdditionalType(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAggregateRating(AggregateRating value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public MusicAlbum.Builder addAggregateRating(AggregateRating.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public MusicAlbum.Builder addAggregateRating(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAlbumProductionType(MusicAlbumProductionType value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/albumProductionType", value);
        }

        @Override
        public MusicAlbum.Builder addAlbumProductionType(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/albumProductionType", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAlbumRelease(MusicRelease value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/albumRelease", value);
        }

        @Override
        public MusicAlbum.Builder addAlbumRelease(MusicRelease.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/albumRelease", value.build());
        }

        @Override
        public MusicAlbum.Builder addAlbumRelease(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/albumRelease", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAlbumReleaseType(MusicAlbumReleaseType value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/albumReleaseType", value);
        }

        @Override
        public MusicAlbum.Builder addAlbumReleaseType(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/albumReleaseType", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAlternateName(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MusicAlbum.Builder addAlternateName(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAlternativeHeadline(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public MusicAlbum.Builder addAlternativeHeadline(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAssociatedMedia(MediaObject value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public MusicAlbum.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public MusicAlbum.Builder addAssociatedMedia(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAudience(Audience value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public MusicAlbum.Builder addAudience(Audience.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public MusicAlbum.Builder addAudience(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAudio(AudioObject value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public MusicAlbum.Builder addAudio(AudioObject.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public MusicAlbum.Builder addAudio(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAuthor(Organization value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MusicAlbum.Builder addAuthor(Organization.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MusicAlbum.Builder addAuthor(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MusicAlbum.Builder addAuthor(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MusicAlbum.Builder addAuthor(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAward(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public MusicAlbum.Builder addAward(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addAwards(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public MusicAlbum.Builder addAwards(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addByArtist(MusicGroup value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/byArtist", value);
        }

        @Override
        public MusicAlbum.Builder addByArtist(MusicGroup.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/byArtist", value.build());
        }

        @Override
        public MusicAlbum.Builder addByArtist(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/byArtist", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addCharacter(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public MusicAlbum.Builder addCharacter(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public MusicAlbum.Builder addCharacter(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addCitation(CreativeWork value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MusicAlbum.Builder addCitation(CreativeWork.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public MusicAlbum.Builder addCitation(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MusicAlbum.Builder addCitation(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addComment(Comment value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public MusicAlbum.Builder addComment(Comment.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public MusicAlbum.Builder addComment(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addCommentCount(Integer value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public MusicAlbum.Builder addCommentCount(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addContentLocation(Place value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public MusicAlbum.Builder addContentLocation(Place.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public MusicAlbum.Builder addContentLocation(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addContentRating(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public MusicAlbum.Builder addContentRating(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addContributor(Organization value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MusicAlbum.Builder addContributor(Organization.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MusicAlbum.Builder addContributor(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MusicAlbum.Builder addContributor(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MusicAlbum.Builder addContributor(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addCopyrightHolder(Organization value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MusicAlbum.Builder addCopyrightHolder(Organization.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MusicAlbum.Builder addCopyrightHolder(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MusicAlbum.Builder addCopyrightHolder(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MusicAlbum.Builder addCopyrightHolder(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addCopyrightYear(Number value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public MusicAlbum.Builder addCopyrightYear(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addCreator(Organization value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MusicAlbum.Builder addCreator(Organization.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MusicAlbum.Builder addCreator(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MusicAlbum.Builder addCreator(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MusicAlbum.Builder addCreator(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addDateCreated(Date value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MusicAlbum.Builder addDateCreated(DateTime value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MusicAlbum.Builder addDateCreated(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addDateModified(Date value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MusicAlbum.Builder addDateModified(DateTime value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MusicAlbum.Builder addDateModified(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addDatePublished(Date value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public MusicAlbum.Builder addDatePublished(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addDescription(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MusicAlbum.Builder addDescription(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addDiscussionUrl(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public MusicAlbum.Builder addDiscussionUrl(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addEditor(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public MusicAlbum.Builder addEditor(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public MusicAlbum.Builder addEditor(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addEducationalAlignment(AlignmentObject value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public MusicAlbum.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public MusicAlbum.Builder addEducationalAlignment(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addEducationalUse(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public MusicAlbum.Builder addEducationalUse(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addEncoding(MediaObject value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public MusicAlbum.Builder addEncoding(MediaObject.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public MusicAlbum.Builder addEncoding(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addEncodings(MediaObject value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public MusicAlbum.Builder addEncodings(MediaObject.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public MusicAlbum.Builder addEncodings(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addExampleOfWork(CreativeWork value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public MusicAlbum.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public MusicAlbum.Builder addExampleOfWork(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addFileFormat(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public MusicAlbum.Builder addFileFormat(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addGenre(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MusicAlbum.Builder addGenre(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MusicAlbum.Builder addGenre(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addHasPart(CreativeWork value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public MusicAlbum.Builder addHasPart(CreativeWork.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public MusicAlbum.Builder addHasPart(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addHeadline(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public MusicAlbum.Builder addHeadline(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addImage(ImageObject value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MusicAlbum.Builder addImage(ImageObject.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MusicAlbum.Builder addImage(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MusicAlbum.Builder addImage(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addInLanguage(Language value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MusicAlbum.Builder addInLanguage(Language.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public MusicAlbum.Builder addInLanguage(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MusicAlbum.Builder addInLanguage(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addInteractionStatistic(InteractionCounter value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public MusicAlbum.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public MusicAlbum.Builder addInteractionStatistic(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addInteractivityType(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public MusicAlbum.Builder addInteractivityType(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addIsBasedOnUrl(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public MusicAlbum.Builder addIsBasedOnUrl(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addIsFamilyFriendly(Boolean value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public MusicAlbum.Builder addIsFamilyFriendly(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addIsPartOf(CreativeWork value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public MusicAlbum.Builder addIsPartOf(CreativeWork.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public MusicAlbum.Builder addIsPartOf(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addKeywords(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public MusicAlbum.Builder addKeywords(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addLearningResourceType(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public MusicAlbum.Builder addLearningResourceType(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addLicense(CreativeWork value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MusicAlbum.Builder addLicense(CreativeWork.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public MusicAlbum.Builder addLicense(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MusicAlbum.Builder addLicense(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addLocationCreated(Place value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public MusicAlbum.Builder addLocationCreated(Place.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public MusicAlbum.Builder addLocationCreated(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addMainEntity(Thing value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public MusicAlbum.Builder addMainEntity(Thing.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public MusicAlbum.Builder addMainEntity(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addMainEntityOfPage(CreativeWork value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MusicAlbum.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MusicAlbum.Builder addMainEntityOfPage(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MusicAlbum.Builder addMainEntityOfPage(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addMentions(Thing value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public MusicAlbum.Builder addMentions(Thing.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public MusicAlbum.Builder addMentions(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addName(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MusicAlbum.Builder addName(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addNumTracks(Integer value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/numTracks", value);
        }

        @Override
        public MusicAlbum.Builder addNumTracks(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/numTracks", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addOffers(Offer value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public MusicAlbum.Builder addOffers(Offer.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public MusicAlbum.Builder addOffers(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addPosition(Integer value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MusicAlbum.Builder addPosition(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MusicAlbum.Builder addPosition(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addPotentialAction(Action value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MusicAlbum.Builder addPotentialAction(Action.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MusicAlbum.Builder addPotentialAction(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addProducer(Organization value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MusicAlbum.Builder addProducer(Organization.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MusicAlbum.Builder addProducer(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MusicAlbum.Builder addProducer(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MusicAlbum.Builder addProducer(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addProvider(Organization value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MusicAlbum.Builder addProvider(Organization.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MusicAlbum.Builder addProvider(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MusicAlbum.Builder addProvider(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MusicAlbum.Builder addProvider(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addPublication(PublicationEvent value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public MusicAlbum.Builder addPublication(PublicationEvent.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public MusicAlbum.Builder addPublication(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addPublisher(Organization value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MusicAlbum.Builder addPublisher(Organization.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MusicAlbum.Builder addPublisher(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MusicAlbum.Builder addPublisher(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MusicAlbum.Builder addPublisher(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addPublishingPrinciples(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public MusicAlbum.Builder addPublishingPrinciples(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addRecordedAt(Event value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public MusicAlbum.Builder addRecordedAt(Event.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public MusicAlbum.Builder addRecordedAt(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addReleasedEvent(PublicationEvent value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public MusicAlbum.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public MusicAlbum.Builder addReleasedEvent(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addReview(Review value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public MusicAlbum.Builder addReview(Review.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public MusicAlbum.Builder addReview(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addReviews(Review value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public MusicAlbum.Builder addReviews(Review.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public MusicAlbum.Builder addReviews(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addSameAs(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MusicAlbum.Builder addSameAs(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addSchemaVersion(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MusicAlbum.Builder addSchemaVersion(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MusicAlbum.Builder addSchemaVersion(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addSourceOrganization(Organization value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public MusicAlbum.Builder addSourceOrganization(Organization.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public MusicAlbum.Builder addSourceOrganization(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addText(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public MusicAlbum.Builder addText(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addThumbnailUrl(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public MusicAlbum.Builder addThumbnailUrl(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addTimeRequired(Duration value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public MusicAlbum.Builder addTimeRequired(Duration.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public MusicAlbum.Builder addTimeRequired(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addTrack(ItemList value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/track", value);
        }

        @Override
        public MusicAlbum.Builder addTrack(ItemList.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/track", value.build());
        }

        @Override
        public MusicAlbum.Builder addTrack(MusicRecording value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/track", value);
        }

        @Override
        public MusicAlbum.Builder addTrack(MusicRecording.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/track", value.build());
        }

        @Override
        public MusicAlbum.Builder addTrack(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/track", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addTracks(MusicRecording value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/tracks", value);
        }

        @Override
        public MusicAlbum.Builder addTracks(MusicRecording.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/tracks", value.build());
        }

        @Override
        public MusicAlbum.Builder addTracks(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/tracks", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addTranslator(Organization value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MusicAlbum.Builder addTranslator(Organization.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MusicAlbum.Builder addTranslator(Person value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MusicAlbum.Builder addTranslator(Person.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MusicAlbum.Builder addTranslator(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addTypicalAgeRange(Text value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public MusicAlbum.Builder addTypicalAgeRange(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addUrl(URL value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MusicAlbum.Builder addUrl(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addVersion(Number value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public MusicAlbum.Builder addVersion(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addVideo(VideoObject value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public MusicAlbum.Builder addVideo(VideoObject.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public MusicAlbum.Builder addVideo(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addWorkExample(CreativeWork value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public MusicAlbum.Builder addWorkExample(CreativeWork.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public MusicAlbum.Builder addWorkExample(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addDetailedDescription(Article value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MusicAlbum.Builder addDetailedDescription(Article.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MusicAlbum.Builder addDetailedDescription(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MusicAlbum.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MusicAlbum.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MusicAlbum.Builder addPopularityScore(String value) {
            return (MusicAlbum.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MusicAlbum build() {
            return new MusicAlbumImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

