/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.ItemList;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.MusicAlbum;
import com.google.schemaorg.core.MusicPlaylistImpl;
import com.google.schemaorg.core.MusicRecording;
import com.google.schemaorg.core.MusicRelease;
import com.google.schemaorg.core.MusicReleaseFormatType;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MusicReleaseImpl
extends MusicPlaylistImpl
implements MusicRelease {
    private static final ImmutableSet<String> PROPERTY_SET = MusicReleaseImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/catalogNumber");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/creditedTo");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/duration");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/musicReleaseFormat");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/numTracks");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/recordLabel");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/releaseOf");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/track");
        builder.add((Object)"http://schema.org/tracks");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MusicReleaseImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MusicRelease";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCatalogNumberList() {
        return this.getProperty("http://schema.org/catalogNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCreditedToList() {
        return this.getProperty("http://schema.org/creditedTo");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDurationList() {
        return this.getProperty("http://schema.org/duration");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMusicReleaseFormatList() {
        return this.getProperty("http://schema.org/musicReleaseFormat");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecordLabelList() {
        return this.getProperty("http://schema.org/recordLabel");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReleaseOfList() {
        return this.getProperty("http://schema.org/releaseOf");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MusicRelease.Builder>
    implements MusicRelease.Builder {
        BuilderImpl() {
        }

        @Override
        public MusicRelease.Builder addAbout(Thing value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public MusicRelease.Builder addAbout(Thing.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public MusicRelease.Builder addAbout(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAccessibilityAPI(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public MusicRelease.Builder addAccessibilityAPI(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAccessibilityControl(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public MusicRelease.Builder addAccessibilityControl(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAccessibilityFeature(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public MusicRelease.Builder addAccessibilityFeature(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAccessibilityHazard(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public MusicRelease.Builder addAccessibilityHazard(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAccountablePerson(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public MusicRelease.Builder addAccountablePerson(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public MusicRelease.Builder addAccountablePerson(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAdditionalType(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MusicRelease.Builder addAdditionalType(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAggregateRating(AggregateRating value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public MusicRelease.Builder addAggregateRating(AggregateRating.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public MusicRelease.Builder addAggregateRating(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAlternateName(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MusicRelease.Builder addAlternateName(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAlternativeHeadline(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public MusicRelease.Builder addAlternativeHeadline(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAssociatedMedia(MediaObject value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public MusicRelease.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public MusicRelease.Builder addAssociatedMedia(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAudience(Audience value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public MusicRelease.Builder addAudience(Audience.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public MusicRelease.Builder addAudience(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAudio(AudioObject value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public MusicRelease.Builder addAudio(AudioObject.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public MusicRelease.Builder addAudio(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAuthor(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MusicRelease.Builder addAuthor(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MusicRelease.Builder addAuthor(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MusicRelease.Builder addAuthor(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MusicRelease.Builder addAuthor(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAward(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public MusicRelease.Builder addAward(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addAwards(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public MusicRelease.Builder addAwards(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addCatalogNumber(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/catalogNumber", value);
        }

        @Override
        public MusicRelease.Builder addCatalogNumber(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/catalogNumber", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addCharacter(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public MusicRelease.Builder addCharacter(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public MusicRelease.Builder addCharacter(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addCitation(CreativeWork value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MusicRelease.Builder addCitation(CreativeWork.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public MusicRelease.Builder addCitation(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MusicRelease.Builder addCitation(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addComment(Comment value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public MusicRelease.Builder addComment(Comment.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public MusicRelease.Builder addComment(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addCommentCount(Integer value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public MusicRelease.Builder addCommentCount(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addContentLocation(Place value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public MusicRelease.Builder addContentLocation(Place.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public MusicRelease.Builder addContentLocation(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addContentRating(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public MusicRelease.Builder addContentRating(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addContributor(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MusicRelease.Builder addContributor(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MusicRelease.Builder addContributor(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MusicRelease.Builder addContributor(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MusicRelease.Builder addContributor(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addCopyrightHolder(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MusicRelease.Builder addCopyrightHolder(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MusicRelease.Builder addCopyrightHolder(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MusicRelease.Builder addCopyrightHolder(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MusicRelease.Builder addCopyrightHolder(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addCopyrightYear(Number value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public MusicRelease.Builder addCopyrightYear(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addCreator(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MusicRelease.Builder addCreator(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MusicRelease.Builder addCreator(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MusicRelease.Builder addCreator(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MusicRelease.Builder addCreator(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addCreditedTo(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/creditedTo", value);
        }

        @Override
        public MusicRelease.Builder addCreditedTo(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/creditedTo", value.build());
        }

        @Override
        public MusicRelease.Builder addCreditedTo(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/creditedTo", value);
        }

        @Override
        public MusicRelease.Builder addCreditedTo(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/creditedTo", value.build());
        }

        @Override
        public MusicRelease.Builder addCreditedTo(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/creditedTo", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addDateCreated(Date value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MusicRelease.Builder addDateCreated(DateTime value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MusicRelease.Builder addDateCreated(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addDateModified(Date value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MusicRelease.Builder addDateModified(DateTime value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MusicRelease.Builder addDateModified(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addDatePublished(Date value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public MusicRelease.Builder addDatePublished(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addDescription(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MusicRelease.Builder addDescription(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addDiscussionUrl(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public MusicRelease.Builder addDiscussionUrl(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addDuration(Duration value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/duration", value);
        }

        @Override
        public MusicRelease.Builder addDuration(Duration.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/duration", value.build());
        }

        @Override
        public MusicRelease.Builder addDuration(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/duration", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addEditor(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public MusicRelease.Builder addEditor(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public MusicRelease.Builder addEditor(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addEducationalAlignment(AlignmentObject value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public MusicRelease.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public MusicRelease.Builder addEducationalAlignment(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addEducationalUse(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public MusicRelease.Builder addEducationalUse(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addEncoding(MediaObject value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public MusicRelease.Builder addEncoding(MediaObject.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public MusicRelease.Builder addEncoding(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addEncodings(MediaObject value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public MusicRelease.Builder addEncodings(MediaObject.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public MusicRelease.Builder addEncodings(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addExampleOfWork(CreativeWork value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public MusicRelease.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public MusicRelease.Builder addExampleOfWork(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addFileFormat(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public MusicRelease.Builder addFileFormat(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addGenre(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MusicRelease.Builder addGenre(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MusicRelease.Builder addGenre(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addHasPart(CreativeWork value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public MusicRelease.Builder addHasPart(CreativeWork.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public MusicRelease.Builder addHasPart(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addHeadline(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public MusicRelease.Builder addHeadline(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addImage(ImageObject value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MusicRelease.Builder addImage(ImageObject.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MusicRelease.Builder addImage(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MusicRelease.Builder addImage(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addInLanguage(Language value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MusicRelease.Builder addInLanguage(Language.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public MusicRelease.Builder addInLanguage(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MusicRelease.Builder addInLanguage(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addInteractionStatistic(InteractionCounter value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public MusicRelease.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public MusicRelease.Builder addInteractionStatistic(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addInteractivityType(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public MusicRelease.Builder addInteractivityType(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addIsBasedOnUrl(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public MusicRelease.Builder addIsBasedOnUrl(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addIsFamilyFriendly(Boolean value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public MusicRelease.Builder addIsFamilyFriendly(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addIsPartOf(CreativeWork value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public MusicRelease.Builder addIsPartOf(CreativeWork.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public MusicRelease.Builder addIsPartOf(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addKeywords(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public MusicRelease.Builder addKeywords(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addLearningResourceType(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public MusicRelease.Builder addLearningResourceType(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addLicense(CreativeWork value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MusicRelease.Builder addLicense(CreativeWork.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public MusicRelease.Builder addLicense(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MusicRelease.Builder addLicense(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addLocationCreated(Place value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public MusicRelease.Builder addLocationCreated(Place.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public MusicRelease.Builder addLocationCreated(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addMainEntity(Thing value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public MusicRelease.Builder addMainEntity(Thing.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public MusicRelease.Builder addMainEntity(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addMainEntityOfPage(CreativeWork value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MusicRelease.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MusicRelease.Builder addMainEntityOfPage(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MusicRelease.Builder addMainEntityOfPage(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addMentions(Thing value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public MusicRelease.Builder addMentions(Thing.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public MusicRelease.Builder addMentions(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addMusicReleaseFormat(MusicReleaseFormatType value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/musicReleaseFormat", value);
        }

        @Override
        public MusicRelease.Builder addMusicReleaseFormat(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/musicReleaseFormat", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addName(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MusicRelease.Builder addName(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addNumTracks(Integer value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/numTracks", value);
        }

        @Override
        public MusicRelease.Builder addNumTracks(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/numTracks", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addOffers(Offer value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public MusicRelease.Builder addOffers(Offer.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public MusicRelease.Builder addOffers(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addPosition(Integer value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MusicRelease.Builder addPosition(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MusicRelease.Builder addPosition(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addPotentialAction(Action value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MusicRelease.Builder addPotentialAction(Action.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MusicRelease.Builder addPotentialAction(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addProducer(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MusicRelease.Builder addProducer(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MusicRelease.Builder addProducer(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MusicRelease.Builder addProducer(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MusicRelease.Builder addProducer(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addProvider(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MusicRelease.Builder addProvider(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MusicRelease.Builder addProvider(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MusicRelease.Builder addProvider(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MusicRelease.Builder addProvider(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addPublication(PublicationEvent value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public MusicRelease.Builder addPublication(PublicationEvent.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public MusicRelease.Builder addPublication(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addPublisher(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MusicRelease.Builder addPublisher(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MusicRelease.Builder addPublisher(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MusicRelease.Builder addPublisher(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MusicRelease.Builder addPublisher(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addPublishingPrinciples(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public MusicRelease.Builder addPublishingPrinciples(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addRecordedAt(Event value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public MusicRelease.Builder addRecordedAt(Event.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public MusicRelease.Builder addRecordedAt(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addRecordLabel(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/recordLabel", value);
        }

        @Override
        public MusicRelease.Builder addRecordLabel(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/recordLabel", value.build());
        }

        @Override
        public MusicRelease.Builder addRecordLabel(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/recordLabel", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addReleasedEvent(PublicationEvent value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public MusicRelease.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public MusicRelease.Builder addReleasedEvent(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addReleaseOf(MusicAlbum value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/releaseOf", value);
        }

        @Override
        public MusicRelease.Builder addReleaseOf(MusicAlbum.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/releaseOf", value.build());
        }

        @Override
        public MusicRelease.Builder addReleaseOf(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/releaseOf", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addReview(Review value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public MusicRelease.Builder addReview(Review.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public MusicRelease.Builder addReview(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addReviews(Review value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public MusicRelease.Builder addReviews(Review.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public MusicRelease.Builder addReviews(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addSameAs(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MusicRelease.Builder addSameAs(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addSchemaVersion(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MusicRelease.Builder addSchemaVersion(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MusicRelease.Builder addSchemaVersion(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addSourceOrganization(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public MusicRelease.Builder addSourceOrganization(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public MusicRelease.Builder addSourceOrganization(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addText(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public MusicRelease.Builder addText(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addThumbnailUrl(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public MusicRelease.Builder addThumbnailUrl(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addTimeRequired(Duration value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public MusicRelease.Builder addTimeRequired(Duration.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public MusicRelease.Builder addTimeRequired(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addTrack(ItemList value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/track", value);
        }

        @Override
        public MusicRelease.Builder addTrack(ItemList.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/track", value.build());
        }

        @Override
        public MusicRelease.Builder addTrack(MusicRecording value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/track", value);
        }

        @Override
        public MusicRelease.Builder addTrack(MusicRecording.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/track", value.build());
        }

        @Override
        public MusicRelease.Builder addTrack(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/track", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addTracks(MusicRecording value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/tracks", value);
        }

        @Override
        public MusicRelease.Builder addTracks(MusicRecording.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/tracks", value.build());
        }

        @Override
        public MusicRelease.Builder addTracks(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/tracks", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addTranslator(Organization value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MusicRelease.Builder addTranslator(Organization.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MusicRelease.Builder addTranslator(Person value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MusicRelease.Builder addTranslator(Person.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MusicRelease.Builder addTranslator(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addTypicalAgeRange(Text value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public MusicRelease.Builder addTypicalAgeRange(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addUrl(URL value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MusicRelease.Builder addUrl(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addVersion(Number value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public MusicRelease.Builder addVersion(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addVideo(VideoObject value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public MusicRelease.Builder addVideo(VideoObject.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public MusicRelease.Builder addVideo(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addWorkExample(CreativeWork value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public MusicRelease.Builder addWorkExample(CreativeWork.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public MusicRelease.Builder addWorkExample(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addDetailedDescription(Article value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MusicRelease.Builder addDetailedDescription(Article.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MusicRelease.Builder addDetailedDescription(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MusicRelease.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MusicRelease.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MusicRelease.Builder addPopularityScore(String value) {
            return (MusicRelease.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MusicRelease build() {
            return new MusicReleaseImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

