/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Class;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Enumeration;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Property;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class PropertyImpl
extends IntangibleImpl
implements Property {
    private static final ImmutableSet<String> PROPERTY_SET = PropertyImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/domainIncludes");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inverseOf");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/rangeIncludes");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/supersededBy");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public PropertyImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Property";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDomainIncludesList() {
        return this.getProperty("http://schema.org/domainIncludes");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInverseOfList() {
        return this.getProperty("http://schema.org/inverseOf");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRangeIncludesList() {
        return this.getProperty("http://schema.org/rangeIncludes");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSupersededByList() {
        return this.getProperty("http://schema.org/supersededBy");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Property.Builder>
    implements Property.Builder {
        BuilderImpl() {
        }

        @Override
        public Property.Builder addAdditionalType(URL value) {
            return (Property.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Property.Builder addAdditionalType(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Property.Builder addAlternateName(Text value) {
            return (Property.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Property.Builder addAlternateName(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Property.Builder addDescription(Text value) {
            return (Property.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Property.Builder addDescription(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Property.Builder addDomainIncludes(Class value) {
            return (Property.Builder)this.addProperty("http://schema.org/domainIncludes", value);
        }

        @Override
        public Property.Builder addDomainIncludes(Class.Builder value) {
            return (Property.Builder)this.addProperty("http://schema.org/domainIncludes", value.build());
        }

        @Override
        public Property.Builder addDomainIncludes(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/domainIncludes", Text.of(value));
        }

        @Override
        public Property.Builder addImage(ImageObject value) {
            return (Property.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Property.Builder addImage(ImageObject.Builder value) {
            return (Property.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Property.Builder addImage(URL value) {
            return (Property.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Property.Builder addImage(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Property.Builder addInverseOf(Property value) {
            return (Property.Builder)this.addProperty("http://schema.org/inverseOf", value);
        }

        @Override
        public Property.Builder addInverseOf(Property.Builder value) {
            return (Property.Builder)this.addProperty("http://schema.org/inverseOf", value.build());
        }

        @Override
        public Property.Builder addInverseOf(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/inverseOf", Text.of(value));
        }

        @Override
        public Property.Builder addMainEntityOfPage(CreativeWork value) {
            return (Property.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Property.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Property.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Property.Builder addMainEntityOfPage(URL value) {
            return (Property.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Property.Builder addMainEntityOfPage(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Property.Builder addName(Text value) {
            return (Property.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Property.Builder addName(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Property.Builder addPotentialAction(Action value) {
            return (Property.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Property.Builder addPotentialAction(Action.Builder value) {
            return (Property.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Property.Builder addPotentialAction(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Property.Builder addRangeIncludes(Class value) {
            return (Property.Builder)this.addProperty("http://schema.org/rangeIncludes", value);
        }

        @Override
        public Property.Builder addRangeIncludes(Class.Builder value) {
            return (Property.Builder)this.addProperty("http://schema.org/rangeIncludes", value.build());
        }

        @Override
        public Property.Builder addRangeIncludes(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/rangeIncludes", Text.of(value));
        }

        @Override
        public Property.Builder addSameAs(URL value) {
            return (Property.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Property.Builder addSameAs(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Property.Builder addSupersededBy(Class value) {
            return (Property.Builder)this.addProperty("http://schema.org/supersededBy", value);
        }

        @Override
        public Property.Builder addSupersededBy(Class.Builder value) {
            return (Property.Builder)this.addProperty("http://schema.org/supersededBy", value.build());
        }

        @Override
        public Property.Builder addSupersededBy(Enumeration value) {
            return (Property.Builder)this.addProperty("http://schema.org/supersededBy", value);
        }

        @Override
        public Property.Builder addSupersededBy(Property value) {
            return (Property.Builder)this.addProperty("http://schema.org/supersededBy", value);
        }

        @Override
        public Property.Builder addSupersededBy(Property.Builder value) {
            return (Property.Builder)this.addProperty("http://schema.org/supersededBy", value.build());
        }

        @Override
        public Property.Builder addSupersededBy(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/supersededBy", Text.of(value));
        }

        @Override
        public Property.Builder addUrl(URL value) {
            return (Property.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Property.Builder addUrl(String value) {
            return (Property.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Property.Builder addDetailedDescription(Article value) {
            return (Property.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Property.Builder addDetailedDescription(Article.Builder value) {
            return (Property.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Property.Builder addDetailedDescription(String value) {
            return (Property.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Property.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Property.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Property.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Property.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Property.Builder addPopularityScore(String value) {
            return (Property.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Property build() {
            return new PropertyImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

