/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Enumeration;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.PropertyValue;
import com.google.schemaorg.core.QualitativeValue;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.StructuredValue;
import com.google.schemaorg.core.StructuredValueImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class PropertyValueImpl
extends StructuredValueImpl
implements PropertyValue {
    private static final ImmutableSet<String> PROPERTY_SET = PropertyValueImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/maxValue");
        builder.add((Object)"http://schema.org/minValue");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/propertyID");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/unitCode");
        builder.add((Object)"http://schema.org/unitText");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/value");
        builder.add((Object)"http://schema.org/valueReference");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public PropertyValueImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/PropertyValue";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getMaxValueList() {
        return this.getProperty("http://schema.org/maxValue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMinValueList() {
        return this.getProperty("http://schema.org/minValue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPropertyIDList() {
        return this.getProperty("http://schema.org/propertyID");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUnitCodeList() {
        return this.getProperty("http://schema.org/unitCode");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUnitTextList() {
        return this.getProperty("http://schema.org/unitText");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValueList() {
        return this.getProperty("http://schema.org/value");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValueReferenceList() {
        return this.getProperty("http://schema.org/valueReference");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<PropertyValue.Builder>
    implements PropertyValue.Builder {
        BuilderImpl() {
        }

        @Override
        public PropertyValue.Builder addAdditionalType(URL value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public PropertyValue.Builder addAdditionalType(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addAlternateName(Text value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public PropertyValue.Builder addAlternateName(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addDescription(Text value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public PropertyValue.Builder addDescription(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addImage(ImageObject value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PropertyValue.Builder addImage(ImageObject.Builder value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public PropertyValue.Builder addImage(URL value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PropertyValue.Builder addImage(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addMainEntityOfPage(CreativeWork value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PropertyValue.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public PropertyValue.Builder addMainEntityOfPage(URL value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PropertyValue.Builder addMainEntityOfPage(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addMaxValue(Number value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/maxValue", value);
        }

        @Override
        public PropertyValue.Builder addMaxValue(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/maxValue", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addMinValue(Number value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/minValue", value);
        }

        @Override
        public PropertyValue.Builder addMinValue(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/minValue", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addName(Text value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public PropertyValue.Builder addName(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addPotentialAction(Action value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public PropertyValue.Builder addPotentialAction(Action.Builder value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public PropertyValue.Builder addPotentialAction(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addPropertyID(Text value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/propertyID", value);
        }

        @Override
        public PropertyValue.Builder addPropertyID(URL value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/propertyID", value);
        }

        @Override
        public PropertyValue.Builder addPropertyID(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/propertyID", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addSameAs(URL value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public PropertyValue.Builder addSameAs(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addUnitCode(Text value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/unitCode", value);
        }

        @Override
        public PropertyValue.Builder addUnitCode(URL value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/unitCode", value);
        }

        @Override
        public PropertyValue.Builder addUnitCode(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/unitCode", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addUnitText(Text value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/unitText", value);
        }

        @Override
        public PropertyValue.Builder addUnitText(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/unitText", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addUrl(URL value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public PropertyValue.Builder addUrl(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addValue(Boolean value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/value", value);
        }

        @Override
        public PropertyValue.Builder addValue(Number value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/value", value);
        }

        @Override
        public PropertyValue.Builder addValue(StructuredValue value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/value", value);
        }

        @Override
        public PropertyValue.Builder addValue(StructuredValue.Builder value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/value", value.build());
        }

        @Override
        public PropertyValue.Builder addValue(Text value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/value", value);
        }

        @Override
        public PropertyValue.Builder addValue(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/value", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addValueReference(Enumeration value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/valueReference", value);
        }

        @Override
        public PropertyValue.Builder addValueReference(PropertyValue value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/valueReference", value);
        }

        @Override
        public PropertyValue.Builder addValueReference(PropertyValue.Builder value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/valueReference", value.build());
        }

        @Override
        public PropertyValue.Builder addValueReference(QualitativeValue value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/valueReference", value);
        }

        @Override
        public PropertyValue.Builder addValueReference(QuantitativeValue value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/valueReference", value);
        }

        @Override
        public PropertyValue.Builder addValueReference(QuantitativeValue.Builder value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/valueReference", value.build());
        }

        @Override
        public PropertyValue.Builder addValueReference(StructuredValue value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/valueReference", value);
        }

        @Override
        public PropertyValue.Builder addValueReference(StructuredValue.Builder value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/valueReference", value.build());
        }

        @Override
        public PropertyValue.Builder addValueReference(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.org/valueReference", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addDetailedDescription(Article value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public PropertyValue.Builder addDetailedDescription(Article.Builder value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public PropertyValue.Builder addDetailedDescription(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public PropertyValue.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public PropertyValue.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public PropertyValue.Builder addPopularityScore(String value) {
            return (PropertyValue.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public PropertyValue build() {
            return new PropertyValueImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

