/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.PropertyValueSpecification;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class PropertyValueSpecificationImpl
extends IntangibleImpl
implements PropertyValueSpecification {
    private static final ImmutableSet<String> PROPERTY_SET = PropertyValueSpecificationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/defaultValue");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/maxValue");
        builder.add((Object)"http://schema.org/minValue");
        builder.add((Object)"http://schema.org/multipleValues");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/readonlyValue");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/stepValue");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/valueMaxLength");
        builder.add((Object)"http://schema.org/valueMinLength");
        builder.add((Object)"http://schema.org/valueName");
        builder.add((Object)"http://schema.org/valuePattern");
        builder.add((Object)"http://schema.org/valueRequired");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public PropertyValueSpecificationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/PropertyValueSpecification";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDefaultValueList() {
        return this.getProperty("http://schema.org/defaultValue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMaxValueList() {
        return this.getProperty("http://schema.org/maxValue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMinValueList() {
        return this.getProperty("http://schema.org/minValue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMultipleValuesList() {
        return this.getProperty("http://schema.org/multipleValues");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReadonlyValueList() {
        return this.getProperty("http://schema.org/readonlyValue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStepValueList() {
        return this.getProperty("http://schema.org/stepValue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValueMaxLengthList() {
        return this.getProperty("http://schema.org/valueMaxLength");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValueMinLengthList() {
        return this.getProperty("http://schema.org/valueMinLength");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValueNameList() {
        return this.getProperty("http://schema.org/valueName");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValuePatternList() {
        return this.getProperty("http://schema.org/valuePattern");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValueRequiredList() {
        return this.getProperty("http://schema.org/valueRequired");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<PropertyValueSpecification.Builder>
    implements PropertyValueSpecification.Builder {
        BuilderImpl() {
        }

        @Override
        public PropertyValueSpecification.Builder addAdditionalType(URL value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public PropertyValueSpecification.Builder addAdditionalType(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addAlternateName(Text value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public PropertyValueSpecification.Builder addAlternateName(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addDefaultValue(Text value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/defaultValue", value);
        }

        @Override
        public PropertyValueSpecification.Builder addDefaultValue(Thing value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/defaultValue", value);
        }

        @Override
        public PropertyValueSpecification.Builder addDefaultValue(Thing.Builder value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/defaultValue", value.build());
        }

        @Override
        public PropertyValueSpecification.Builder addDefaultValue(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/defaultValue", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addDescription(Text value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public PropertyValueSpecification.Builder addDescription(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addImage(ImageObject value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PropertyValueSpecification.Builder addImage(ImageObject.Builder value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public PropertyValueSpecification.Builder addImage(URL value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PropertyValueSpecification.Builder addImage(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addMainEntityOfPage(CreativeWork value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PropertyValueSpecification.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public PropertyValueSpecification.Builder addMainEntityOfPage(URL value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PropertyValueSpecification.Builder addMainEntityOfPage(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addMaxValue(Number value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/maxValue", value);
        }

        @Override
        public PropertyValueSpecification.Builder addMaxValue(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/maxValue", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addMinValue(Number value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/minValue", value);
        }

        @Override
        public PropertyValueSpecification.Builder addMinValue(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/minValue", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addMultipleValues(Boolean value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/multipleValues", value);
        }

        @Override
        public PropertyValueSpecification.Builder addMultipleValues(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/multipleValues", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addName(Text value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public PropertyValueSpecification.Builder addName(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addPotentialAction(Action value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public PropertyValueSpecification.Builder addPotentialAction(Action.Builder value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public PropertyValueSpecification.Builder addPotentialAction(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addReadonlyValue(Boolean value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/readonlyValue", value);
        }

        @Override
        public PropertyValueSpecification.Builder addReadonlyValue(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/readonlyValue", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addSameAs(URL value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public PropertyValueSpecification.Builder addSameAs(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addStepValue(Number value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/stepValue", value);
        }

        @Override
        public PropertyValueSpecification.Builder addStepValue(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/stepValue", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addUrl(URL value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public PropertyValueSpecification.Builder addUrl(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addValueMaxLength(Number value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/valueMaxLength", value);
        }

        @Override
        public PropertyValueSpecification.Builder addValueMaxLength(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/valueMaxLength", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addValueMinLength(Number value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/valueMinLength", value);
        }

        @Override
        public PropertyValueSpecification.Builder addValueMinLength(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/valueMinLength", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addValueName(Text value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/valueName", value);
        }

        @Override
        public PropertyValueSpecification.Builder addValueName(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/valueName", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addValuePattern(Text value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/valuePattern", value);
        }

        @Override
        public PropertyValueSpecification.Builder addValuePattern(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/valuePattern", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addValueRequired(Boolean value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/valueRequired", value);
        }

        @Override
        public PropertyValueSpecification.Builder addValueRequired(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.org/valueRequired", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addDetailedDescription(Article value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public PropertyValueSpecification.Builder addDetailedDescription(Article.Builder value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public PropertyValueSpecification.Builder addDetailedDescription(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public PropertyValueSpecification.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public PropertyValueSpecification.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public PropertyValueSpecification.Builder addPopularityScore(String value) {
            return (PropertyValueSpecification.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public PropertyValueSpecification build() {
            return new PropertyValueSpecificationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

