/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Answer;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Question;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class QuestionImpl
extends CreativeWorkImpl
implements Question {
    private static final ImmutableSet<String> PROPERTY_SET = QuestionImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/acceptedAnswer");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/answerCount");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/downvoteCount");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/suggestedAnswer");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/upvoteCount");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public QuestionImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Question";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAcceptedAnswerList() {
        return this.getProperty("http://schema.org/acceptedAnswer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAnswerCountList() {
        return this.getProperty("http://schema.org/answerCount");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDownvoteCountList() {
        return this.getProperty("http://schema.org/downvoteCount");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSuggestedAnswerList() {
        return this.getProperty("http://schema.org/suggestedAnswer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUpvoteCountList() {
        return this.getProperty("http://schema.org/upvoteCount");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Question.Builder>
    implements Question.Builder {
        BuilderImpl() {
        }

        @Override
        public Question.Builder addAbout(Thing value) {
            return (Question.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Question.Builder addAbout(Thing.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Question.Builder addAbout(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Question.Builder addAcceptedAnswer(Answer value) {
            return (Question.Builder)this.addProperty("http://schema.org/acceptedAnswer", value);
        }

        @Override
        public Question.Builder addAcceptedAnswer(Answer.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/acceptedAnswer", value.build());
        }

        @Override
        public Question.Builder addAcceptedAnswer(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/acceptedAnswer", Text.of(value));
        }

        @Override
        public Question.Builder addAccessibilityAPI(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Question.Builder addAccessibilityAPI(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Question.Builder addAccessibilityControl(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Question.Builder addAccessibilityControl(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Question.Builder addAccessibilityFeature(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Question.Builder addAccessibilityFeature(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Question.Builder addAccessibilityHazard(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Question.Builder addAccessibilityHazard(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Question.Builder addAccountablePerson(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Question.Builder addAccountablePerson(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Question.Builder addAccountablePerson(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Question.Builder addAdditionalType(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Question.Builder addAdditionalType(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Question.Builder addAggregateRating(AggregateRating value) {
            return (Question.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Question.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Question.Builder addAggregateRating(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Question.Builder addAlternateName(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Question.Builder addAlternateName(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Question.Builder addAlternativeHeadline(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Question.Builder addAlternativeHeadline(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Question.Builder addAnswerCount(Integer value) {
            return (Question.Builder)this.addProperty("http://schema.org/answerCount", value);
        }

        @Override
        public Question.Builder addAnswerCount(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/answerCount", Text.of(value));
        }

        @Override
        public Question.Builder addAssociatedMedia(MediaObject value) {
            return (Question.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Question.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Question.Builder addAssociatedMedia(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Question.Builder addAudience(Audience value) {
            return (Question.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Question.Builder addAudience(Audience.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Question.Builder addAudience(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Question.Builder addAudio(AudioObject value) {
            return (Question.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Question.Builder addAudio(AudioObject.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Question.Builder addAudio(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Question.Builder addAuthor(Organization value) {
            return (Question.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Question.Builder addAuthor(Organization.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Question.Builder addAuthor(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Question.Builder addAuthor(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Question.Builder addAuthor(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Question.Builder addAward(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Question.Builder addAward(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Question.Builder addAwards(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Question.Builder addAwards(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Question.Builder addCharacter(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Question.Builder addCharacter(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Question.Builder addCharacter(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Question.Builder addCitation(CreativeWork value) {
            return (Question.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Question.Builder addCitation(CreativeWork.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Question.Builder addCitation(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Question.Builder addCitation(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Question.Builder addComment(Comment value) {
            return (Question.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Question.Builder addComment(Comment.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Question.Builder addComment(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Question.Builder addCommentCount(Integer value) {
            return (Question.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Question.Builder addCommentCount(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Question.Builder addContentLocation(Place value) {
            return (Question.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Question.Builder addContentLocation(Place.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Question.Builder addContentLocation(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Question.Builder addContentRating(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Question.Builder addContentRating(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Question.Builder addContributor(Organization value) {
            return (Question.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Question.Builder addContributor(Organization.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Question.Builder addContributor(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Question.Builder addContributor(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Question.Builder addContributor(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Question.Builder addCopyrightHolder(Organization value) {
            return (Question.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Question.Builder addCopyrightHolder(Organization.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Question.Builder addCopyrightHolder(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Question.Builder addCopyrightHolder(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Question.Builder addCopyrightHolder(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Question.Builder addCopyrightYear(Number value) {
            return (Question.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Question.Builder addCopyrightYear(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Question.Builder addCreator(Organization value) {
            return (Question.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Question.Builder addCreator(Organization.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Question.Builder addCreator(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Question.Builder addCreator(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Question.Builder addCreator(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Question.Builder addDateCreated(Date value) {
            return (Question.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Question.Builder addDateCreated(DateTime value) {
            return (Question.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Question.Builder addDateCreated(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Question.Builder addDateModified(Date value) {
            return (Question.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Question.Builder addDateModified(DateTime value) {
            return (Question.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Question.Builder addDateModified(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Question.Builder addDatePublished(Date value) {
            return (Question.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Question.Builder addDatePublished(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Question.Builder addDescription(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Question.Builder addDescription(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Question.Builder addDiscussionUrl(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Question.Builder addDiscussionUrl(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Question.Builder addDownvoteCount(Integer value) {
            return (Question.Builder)this.addProperty("http://schema.org/downvoteCount", value);
        }

        @Override
        public Question.Builder addDownvoteCount(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/downvoteCount", Text.of(value));
        }

        @Override
        public Question.Builder addEditor(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Question.Builder addEditor(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Question.Builder addEditor(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Question.Builder addEducationalAlignment(AlignmentObject value) {
            return (Question.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Question.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Question.Builder addEducationalAlignment(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Question.Builder addEducationalUse(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Question.Builder addEducationalUse(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Question.Builder addEncoding(MediaObject value) {
            return (Question.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Question.Builder addEncoding(MediaObject.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Question.Builder addEncoding(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Question.Builder addEncodings(MediaObject value) {
            return (Question.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Question.Builder addEncodings(MediaObject.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Question.Builder addEncodings(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Question.Builder addExampleOfWork(CreativeWork value) {
            return (Question.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Question.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Question.Builder addExampleOfWork(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Question.Builder addFileFormat(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Question.Builder addFileFormat(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Question.Builder addGenre(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Question.Builder addGenre(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Question.Builder addGenre(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Question.Builder addHasPart(CreativeWork value) {
            return (Question.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Question.Builder addHasPart(CreativeWork.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Question.Builder addHasPart(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Question.Builder addHeadline(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Question.Builder addHeadline(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Question.Builder addImage(ImageObject value) {
            return (Question.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Question.Builder addImage(ImageObject.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Question.Builder addImage(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Question.Builder addImage(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Question.Builder addInLanguage(Language value) {
            return (Question.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Question.Builder addInLanguage(Language.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Question.Builder addInLanguage(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Question.Builder addInLanguage(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Question.Builder addInteractionStatistic(InteractionCounter value) {
            return (Question.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Question.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Question.Builder addInteractionStatistic(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Question.Builder addInteractivityType(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Question.Builder addInteractivityType(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Question.Builder addIsBasedOnUrl(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Question.Builder addIsBasedOnUrl(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Question.Builder addIsFamilyFriendly(Boolean value) {
            return (Question.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Question.Builder addIsFamilyFriendly(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Question.Builder addIsPartOf(CreativeWork value) {
            return (Question.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Question.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Question.Builder addIsPartOf(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Question.Builder addKeywords(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Question.Builder addKeywords(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Question.Builder addLearningResourceType(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Question.Builder addLearningResourceType(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Question.Builder addLicense(CreativeWork value) {
            return (Question.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Question.Builder addLicense(CreativeWork.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Question.Builder addLicense(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Question.Builder addLicense(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Question.Builder addLocationCreated(Place value) {
            return (Question.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Question.Builder addLocationCreated(Place.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Question.Builder addLocationCreated(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Question.Builder addMainEntity(Thing value) {
            return (Question.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Question.Builder addMainEntity(Thing.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Question.Builder addMainEntity(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Question.Builder addMainEntityOfPage(CreativeWork value) {
            return (Question.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Question.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Question.Builder addMainEntityOfPage(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Question.Builder addMainEntityOfPage(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Question.Builder addMentions(Thing value) {
            return (Question.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Question.Builder addMentions(Thing.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Question.Builder addMentions(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Question.Builder addName(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Question.Builder addName(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Question.Builder addOffers(Offer value) {
            return (Question.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Question.Builder addOffers(Offer.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Question.Builder addOffers(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Question.Builder addPosition(Integer value) {
            return (Question.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Question.Builder addPosition(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Question.Builder addPosition(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Question.Builder addPotentialAction(Action value) {
            return (Question.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Question.Builder addPotentialAction(Action.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Question.Builder addPotentialAction(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Question.Builder addProducer(Organization value) {
            return (Question.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Question.Builder addProducer(Organization.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Question.Builder addProducer(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Question.Builder addProducer(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Question.Builder addProducer(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Question.Builder addProvider(Organization value) {
            return (Question.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Question.Builder addProvider(Organization.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Question.Builder addProvider(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Question.Builder addProvider(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Question.Builder addProvider(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Question.Builder addPublication(PublicationEvent value) {
            return (Question.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Question.Builder addPublication(PublicationEvent.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Question.Builder addPublication(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Question.Builder addPublisher(Organization value) {
            return (Question.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Question.Builder addPublisher(Organization.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Question.Builder addPublisher(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Question.Builder addPublisher(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Question.Builder addPublisher(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Question.Builder addPublishingPrinciples(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Question.Builder addPublishingPrinciples(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Question.Builder addRecordedAt(Event value) {
            return (Question.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Question.Builder addRecordedAt(Event.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Question.Builder addRecordedAt(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Question.Builder addReleasedEvent(PublicationEvent value) {
            return (Question.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Question.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Question.Builder addReleasedEvent(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Question.Builder addReview(Review value) {
            return (Question.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Question.Builder addReview(Review.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Question.Builder addReview(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Question.Builder addReviews(Review value) {
            return (Question.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Question.Builder addReviews(Review.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Question.Builder addReviews(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Question.Builder addSameAs(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Question.Builder addSameAs(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Question.Builder addSchemaVersion(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Question.Builder addSchemaVersion(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Question.Builder addSchemaVersion(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Question.Builder addSourceOrganization(Organization value) {
            return (Question.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Question.Builder addSourceOrganization(Organization.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Question.Builder addSourceOrganization(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Question.Builder addSuggestedAnswer(Answer value) {
            return (Question.Builder)this.addProperty("http://schema.org/suggestedAnswer", value);
        }

        @Override
        public Question.Builder addSuggestedAnswer(Answer.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/suggestedAnswer", value.build());
        }

        @Override
        public Question.Builder addSuggestedAnswer(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/suggestedAnswer", Text.of(value));
        }

        @Override
        public Question.Builder addText(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Question.Builder addText(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Question.Builder addThumbnailUrl(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Question.Builder addThumbnailUrl(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Question.Builder addTimeRequired(Duration value) {
            return (Question.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Question.Builder addTimeRequired(Duration.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Question.Builder addTimeRequired(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Question.Builder addTranslator(Organization value) {
            return (Question.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Question.Builder addTranslator(Organization.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Question.Builder addTranslator(Person value) {
            return (Question.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Question.Builder addTranslator(Person.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Question.Builder addTranslator(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Question.Builder addTypicalAgeRange(Text value) {
            return (Question.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Question.Builder addTypicalAgeRange(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Question.Builder addUpvoteCount(Integer value) {
            return (Question.Builder)this.addProperty("http://schema.org/upvoteCount", value);
        }

        @Override
        public Question.Builder addUpvoteCount(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/upvoteCount", Text.of(value));
        }

        @Override
        public Question.Builder addUrl(URL value) {
            return (Question.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Question.Builder addUrl(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Question.Builder addVersion(Number value) {
            return (Question.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Question.Builder addVersion(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Question.Builder addVideo(VideoObject value) {
            return (Question.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Question.Builder addVideo(VideoObject.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Question.Builder addVideo(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Question.Builder addWorkExample(CreativeWork value) {
            return (Question.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Question.Builder addWorkExample(CreativeWork.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Question.Builder addWorkExample(String value) {
            return (Question.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Question.Builder addDetailedDescription(Article value) {
            return (Question.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Question.Builder addDetailedDescription(Article.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Question.Builder addDetailedDescription(String value) {
            return (Question.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Question.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Question.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Question.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Question.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Question.Builder addPopularityScore(String value) {
            return (Question.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Question build() {
            return new QuestionImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

