/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.ItemList;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.NutritionInformation;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Recipe;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class RecipeImpl
extends CreativeWorkImpl
implements Recipe {
    private static final ImmutableSet<String> PROPERTY_SET = RecipeImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/cookingMethod");
        builder.add((Object)"http://schema.org/cookTime");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/ingredients");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/nutrition");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/prepTime");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recipeCategory");
        builder.add((Object)"http://schema.org/recipeCuisine");
        builder.add((Object)"http://schema.org/recipeIngredient");
        builder.add((Object)"http://schema.org/recipeInstructions");
        builder.add((Object)"http://schema.org/recipeYield");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/totalTime");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public RecipeImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Recipe";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCookingMethodList() {
        return this.getProperty("http://schema.org/cookingMethod");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCookTimeList() {
        return this.getProperty("http://schema.org/cookTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIngredientsList() {
        return this.getProperty("http://schema.org/ingredients");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNutritionList() {
        return this.getProperty("http://schema.org/nutrition");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPrepTimeList() {
        return this.getProperty("http://schema.org/prepTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecipeCategoryList() {
        return this.getProperty("http://schema.org/recipeCategory");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecipeCuisineList() {
        return this.getProperty("http://schema.org/recipeCuisine");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecipeIngredientList() {
        return this.getProperty("http://schema.org/recipeIngredient");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecipeInstructionsList() {
        return this.getProperty("http://schema.org/recipeInstructions");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecipeYieldList() {
        return this.getProperty("http://schema.org/recipeYield");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTotalTimeList() {
        return this.getProperty("http://schema.org/totalTime");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Recipe.Builder>
    implements Recipe.Builder {
        BuilderImpl() {
        }

        @Override
        public Recipe.Builder addAbout(Thing value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Recipe.Builder addAbout(Thing.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Recipe.Builder addAbout(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Recipe.Builder addAccessibilityAPI(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Recipe.Builder addAccessibilityAPI(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Recipe.Builder addAccessibilityControl(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Recipe.Builder addAccessibilityControl(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Recipe.Builder addAccessibilityFeature(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Recipe.Builder addAccessibilityFeature(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Recipe.Builder addAccessibilityHazard(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Recipe.Builder addAccessibilityHazard(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Recipe.Builder addAccountablePerson(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Recipe.Builder addAccountablePerson(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Recipe.Builder addAccountablePerson(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Recipe.Builder addAdditionalType(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Recipe.Builder addAdditionalType(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Recipe.Builder addAggregateRating(AggregateRating value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Recipe.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Recipe.Builder addAggregateRating(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Recipe.Builder addAlternateName(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Recipe.Builder addAlternateName(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Recipe.Builder addAlternativeHeadline(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Recipe.Builder addAlternativeHeadline(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Recipe.Builder addAssociatedMedia(MediaObject value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Recipe.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Recipe.Builder addAssociatedMedia(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Recipe.Builder addAudience(Audience value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Recipe.Builder addAudience(Audience.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Recipe.Builder addAudience(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Recipe.Builder addAudio(AudioObject value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Recipe.Builder addAudio(AudioObject.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Recipe.Builder addAudio(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Recipe.Builder addAuthor(Organization value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Recipe.Builder addAuthor(Organization.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Recipe.Builder addAuthor(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Recipe.Builder addAuthor(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Recipe.Builder addAuthor(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Recipe.Builder addAward(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Recipe.Builder addAward(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Recipe.Builder addAwards(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Recipe.Builder addAwards(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Recipe.Builder addCharacter(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Recipe.Builder addCharacter(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Recipe.Builder addCharacter(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Recipe.Builder addCitation(CreativeWork value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Recipe.Builder addCitation(CreativeWork.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Recipe.Builder addCitation(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Recipe.Builder addCitation(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Recipe.Builder addComment(Comment value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Recipe.Builder addComment(Comment.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Recipe.Builder addComment(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Recipe.Builder addCommentCount(Integer value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Recipe.Builder addCommentCount(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Recipe.Builder addContentLocation(Place value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Recipe.Builder addContentLocation(Place.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Recipe.Builder addContentLocation(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Recipe.Builder addContentRating(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Recipe.Builder addContentRating(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Recipe.Builder addContributor(Organization value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Recipe.Builder addContributor(Organization.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Recipe.Builder addContributor(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Recipe.Builder addContributor(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Recipe.Builder addContributor(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Recipe.Builder addCookingMethod(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/cookingMethod", value);
        }

        @Override
        public Recipe.Builder addCookingMethod(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/cookingMethod", Text.of(value));
        }

        @Override
        public Recipe.Builder addCookTime(Duration value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/cookTime", value);
        }

        @Override
        public Recipe.Builder addCookTime(Duration.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/cookTime", value.build());
        }

        @Override
        public Recipe.Builder addCookTime(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/cookTime", Text.of(value));
        }

        @Override
        public Recipe.Builder addCopyrightHolder(Organization value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Recipe.Builder addCopyrightHolder(Organization.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Recipe.Builder addCopyrightHolder(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Recipe.Builder addCopyrightHolder(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Recipe.Builder addCopyrightHolder(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Recipe.Builder addCopyrightYear(Number value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Recipe.Builder addCopyrightYear(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Recipe.Builder addCreator(Organization value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Recipe.Builder addCreator(Organization.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Recipe.Builder addCreator(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Recipe.Builder addCreator(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Recipe.Builder addCreator(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Recipe.Builder addDateCreated(Date value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Recipe.Builder addDateCreated(DateTime value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Recipe.Builder addDateCreated(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Recipe.Builder addDateModified(Date value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Recipe.Builder addDateModified(DateTime value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Recipe.Builder addDateModified(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Recipe.Builder addDatePublished(Date value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Recipe.Builder addDatePublished(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Recipe.Builder addDescription(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Recipe.Builder addDescription(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Recipe.Builder addDiscussionUrl(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Recipe.Builder addDiscussionUrl(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Recipe.Builder addEditor(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Recipe.Builder addEditor(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Recipe.Builder addEditor(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Recipe.Builder addEducationalAlignment(AlignmentObject value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Recipe.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Recipe.Builder addEducationalAlignment(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Recipe.Builder addEducationalUse(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Recipe.Builder addEducationalUse(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Recipe.Builder addEncoding(MediaObject value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Recipe.Builder addEncoding(MediaObject.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Recipe.Builder addEncoding(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Recipe.Builder addEncodings(MediaObject value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Recipe.Builder addEncodings(MediaObject.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Recipe.Builder addEncodings(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Recipe.Builder addExampleOfWork(CreativeWork value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Recipe.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Recipe.Builder addExampleOfWork(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Recipe.Builder addFileFormat(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Recipe.Builder addFileFormat(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Recipe.Builder addGenre(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Recipe.Builder addGenre(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Recipe.Builder addGenre(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Recipe.Builder addHasPart(CreativeWork value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Recipe.Builder addHasPart(CreativeWork.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Recipe.Builder addHasPart(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Recipe.Builder addHeadline(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Recipe.Builder addHeadline(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Recipe.Builder addImage(ImageObject value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Recipe.Builder addImage(ImageObject.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Recipe.Builder addImage(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Recipe.Builder addImage(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Recipe.Builder addIngredients(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/ingredients", value);
        }

        @Override
        public Recipe.Builder addIngredients(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/ingredients", Text.of(value));
        }

        @Override
        public Recipe.Builder addInLanguage(Language value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Recipe.Builder addInLanguage(Language.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Recipe.Builder addInLanguage(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Recipe.Builder addInLanguage(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Recipe.Builder addInteractionStatistic(InteractionCounter value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Recipe.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Recipe.Builder addInteractionStatistic(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Recipe.Builder addInteractivityType(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Recipe.Builder addInteractivityType(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Recipe.Builder addIsBasedOnUrl(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Recipe.Builder addIsBasedOnUrl(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Recipe.Builder addIsFamilyFriendly(Boolean value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Recipe.Builder addIsFamilyFriendly(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Recipe.Builder addIsPartOf(CreativeWork value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Recipe.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Recipe.Builder addIsPartOf(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Recipe.Builder addKeywords(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Recipe.Builder addKeywords(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Recipe.Builder addLearningResourceType(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Recipe.Builder addLearningResourceType(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Recipe.Builder addLicense(CreativeWork value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Recipe.Builder addLicense(CreativeWork.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Recipe.Builder addLicense(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Recipe.Builder addLicense(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Recipe.Builder addLocationCreated(Place value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Recipe.Builder addLocationCreated(Place.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Recipe.Builder addLocationCreated(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Recipe.Builder addMainEntity(Thing value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Recipe.Builder addMainEntity(Thing.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Recipe.Builder addMainEntity(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Recipe.Builder addMainEntityOfPage(CreativeWork value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Recipe.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Recipe.Builder addMainEntityOfPage(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Recipe.Builder addMainEntityOfPage(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Recipe.Builder addMentions(Thing value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Recipe.Builder addMentions(Thing.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Recipe.Builder addMentions(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Recipe.Builder addName(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Recipe.Builder addName(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Recipe.Builder addNutrition(NutritionInformation value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/nutrition", value);
        }

        @Override
        public Recipe.Builder addNutrition(NutritionInformation.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/nutrition", value.build());
        }

        @Override
        public Recipe.Builder addNutrition(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/nutrition", Text.of(value));
        }

        @Override
        public Recipe.Builder addOffers(Offer value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Recipe.Builder addOffers(Offer.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Recipe.Builder addOffers(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Recipe.Builder addPosition(Integer value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Recipe.Builder addPosition(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Recipe.Builder addPosition(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Recipe.Builder addPotentialAction(Action value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Recipe.Builder addPotentialAction(Action.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Recipe.Builder addPotentialAction(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Recipe.Builder addPrepTime(Duration value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/prepTime", value);
        }

        @Override
        public Recipe.Builder addPrepTime(Duration.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/prepTime", value.build());
        }

        @Override
        public Recipe.Builder addPrepTime(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/prepTime", Text.of(value));
        }

        @Override
        public Recipe.Builder addProducer(Organization value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Recipe.Builder addProducer(Organization.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Recipe.Builder addProducer(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Recipe.Builder addProducer(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Recipe.Builder addProducer(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Recipe.Builder addProvider(Organization value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Recipe.Builder addProvider(Organization.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Recipe.Builder addProvider(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Recipe.Builder addProvider(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Recipe.Builder addProvider(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Recipe.Builder addPublication(PublicationEvent value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Recipe.Builder addPublication(PublicationEvent.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Recipe.Builder addPublication(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Recipe.Builder addPublisher(Organization value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Recipe.Builder addPublisher(Organization.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Recipe.Builder addPublisher(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Recipe.Builder addPublisher(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Recipe.Builder addPublisher(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Recipe.Builder addPublishingPrinciples(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Recipe.Builder addPublishingPrinciples(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Recipe.Builder addRecipeCategory(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeCategory", value);
        }

        @Override
        public Recipe.Builder addRecipeCategory(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeCategory", Text.of(value));
        }

        @Override
        public Recipe.Builder addRecipeCuisine(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeCuisine", value);
        }

        @Override
        public Recipe.Builder addRecipeCuisine(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeCuisine", Text.of(value));
        }

        @Override
        public Recipe.Builder addRecipeIngredient(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeIngredient", value);
        }

        @Override
        public Recipe.Builder addRecipeIngredient(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeIngredient", Text.of(value));
        }

        @Override
        public Recipe.Builder addRecipeInstructions(ItemList value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeInstructions", value);
        }

        @Override
        public Recipe.Builder addRecipeInstructions(ItemList.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeInstructions", value.build());
        }

        @Override
        public Recipe.Builder addRecipeInstructions(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeInstructions", value);
        }

        @Override
        public Recipe.Builder addRecipeInstructions(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeInstructions", Text.of(value));
        }

        @Override
        public Recipe.Builder addRecipeYield(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeYield", value);
        }

        @Override
        public Recipe.Builder addRecipeYield(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recipeYield", Text.of(value));
        }

        @Override
        public Recipe.Builder addRecordedAt(Event value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Recipe.Builder addRecordedAt(Event.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Recipe.Builder addRecordedAt(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Recipe.Builder addReleasedEvent(PublicationEvent value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Recipe.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Recipe.Builder addReleasedEvent(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Recipe.Builder addReview(Review value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Recipe.Builder addReview(Review.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Recipe.Builder addReview(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Recipe.Builder addReviews(Review value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Recipe.Builder addReviews(Review.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Recipe.Builder addReviews(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Recipe.Builder addSameAs(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Recipe.Builder addSameAs(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Recipe.Builder addSchemaVersion(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Recipe.Builder addSchemaVersion(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Recipe.Builder addSchemaVersion(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Recipe.Builder addSourceOrganization(Organization value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Recipe.Builder addSourceOrganization(Organization.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Recipe.Builder addSourceOrganization(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Recipe.Builder addText(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Recipe.Builder addText(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Recipe.Builder addThumbnailUrl(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Recipe.Builder addThumbnailUrl(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Recipe.Builder addTimeRequired(Duration value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Recipe.Builder addTimeRequired(Duration.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Recipe.Builder addTimeRequired(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Recipe.Builder addTotalTime(Duration value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/totalTime", value);
        }

        @Override
        public Recipe.Builder addTotalTime(Duration.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/totalTime", value.build());
        }

        @Override
        public Recipe.Builder addTotalTime(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/totalTime", Text.of(value));
        }

        @Override
        public Recipe.Builder addTranslator(Organization value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Recipe.Builder addTranslator(Organization.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Recipe.Builder addTranslator(Person value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Recipe.Builder addTranslator(Person.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Recipe.Builder addTranslator(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Recipe.Builder addTypicalAgeRange(Text value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Recipe.Builder addTypicalAgeRange(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Recipe.Builder addUrl(URL value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Recipe.Builder addUrl(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Recipe.Builder addVersion(Number value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Recipe.Builder addVersion(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Recipe.Builder addVideo(VideoObject value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Recipe.Builder addVideo(VideoObject.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Recipe.Builder addVideo(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Recipe.Builder addWorkExample(CreativeWork value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Recipe.Builder addWorkExample(CreativeWork.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Recipe.Builder addWorkExample(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Recipe.Builder addDetailedDescription(Article value) {
            return (Recipe.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Recipe.Builder addDetailedDescription(Article.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Recipe.Builder addDetailedDescription(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Recipe.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Recipe.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Recipe.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Recipe.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Recipe.Builder addPopularityScore(String value) {
            return (Recipe.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Recipe build() {
            return new RecipeImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

