/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.GeoShape;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.OfferCatalog;
import com.google.schemaorg.core.OpeningHoursSpecification;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.PhysicalActivityCategory;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Service;
import com.google.schemaorg.core.ServiceChannel;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ServiceImpl
extends IntangibleImpl
implements Service {
    private static final ImmutableSet<String> PROPERTY_SET = ServiceImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/areaServed");
        builder.add((Object)"http://schema.org/availableChannel");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/category");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/hasOfferCatalog");
        builder.add((Object)"http://schema.org/hoursAvailable");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/produces");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/providerMobility");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/serviceArea");
        builder.add((Object)"http://schema.org/serviceAudience");
        builder.add((Object)"http://schema.org/serviceOutput");
        builder.add((Object)"http://schema.org/serviceType");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ServiceImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Service";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAggregateRatingList() {
        return this.getProperty("http://schema.org/aggregateRating");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAreaServedList() {
        return this.getProperty("http://schema.org/areaServed");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailableChannelList() {
        return this.getProperty("http://schema.org/availableChannel");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAwardList() {
        return this.getProperty("http://schema.org/award");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCategoryList() {
        return this.getProperty("http://schema.org/category");
    }

    @Override
    public ImmutableList<SchemaOrgType> getHasOfferCatalogList() {
        return this.getProperty("http://schema.org/hasOfferCatalog");
    }

    @Override
    public ImmutableList<SchemaOrgType> getHoursAvailableList() {
        return this.getProperty("http://schema.org/hoursAvailable");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOffersList() {
        return this.getProperty("http://schema.org/offers");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProducesList() {
        return this.getProperty("http://schema.org/produces");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProviderList() {
        return this.getProperty("http://schema.org/provider");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProviderMobilityList() {
        return this.getProperty("http://schema.org/providerMobility");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewList() {
        return this.getProperty("http://schema.org/review");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServiceAreaList() {
        return this.getProperty("http://schema.org/serviceArea");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServiceAudienceList() {
        return this.getProperty("http://schema.org/serviceAudience");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServiceOutputList() {
        return this.getProperty("http://schema.org/serviceOutput");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServiceTypeList() {
        return this.getProperty("http://schema.org/serviceType");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Service.Builder>
    implements Service.Builder {
        BuilderImpl() {
        }

        @Override
        public Service.Builder addAdditionalType(URL value) {
            return (Service.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Service.Builder addAdditionalType(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Service.Builder addAggregateRating(AggregateRating value) {
            return (Service.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Service.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Service.Builder addAggregateRating(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Service.Builder addAlternateName(Text value) {
            return (Service.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Service.Builder addAlternateName(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Service.Builder addAreaServed(AdministrativeArea value) {
            return (Service.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Service.Builder addAreaServed(AdministrativeArea.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public Service.Builder addAreaServed(GeoShape value) {
            return (Service.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Service.Builder addAreaServed(GeoShape.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public Service.Builder addAreaServed(Place value) {
            return (Service.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Service.Builder addAreaServed(Place.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public Service.Builder addAreaServed(Text value) {
            return (Service.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Service.Builder addAreaServed(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/areaServed", Text.of(value));
        }

        @Override
        public Service.Builder addAvailableChannel(ServiceChannel value) {
            return (Service.Builder)this.addProperty("http://schema.org/availableChannel", value);
        }

        @Override
        public Service.Builder addAvailableChannel(ServiceChannel.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/availableChannel", value.build());
        }

        @Override
        public Service.Builder addAvailableChannel(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/availableChannel", Text.of(value));
        }

        @Override
        public Service.Builder addAward(Text value) {
            return (Service.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Service.Builder addAward(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Service.Builder addCategory(PhysicalActivityCategory value) {
            return (Service.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public Service.Builder addCategory(Text value) {
            return (Service.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public Service.Builder addCategory(Thing value) {
            return (Service.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public Service.Builder addCategory(Thing.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/category", value.build());
        }

        @Override
        public Service.Builder addCategory(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/category", Text.of(value));
        }

        @Override
        public Service.Builder addDescription(Text value) {
            return (Service.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Service.Builder addDescription(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Service.Builder addHasOfferCatalog(OfferCatalog value) {
            return (Service.Builder)this.addProperty("http://schema.org/hasOfferCatalog", value);
        }

        @Override
        public Service.Builder addHasOfferCatalog(OfferCatalog.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/hasOfferCatalog", value.build());
        }

        @Override
        public Service.Builder addHasOfferCatalog(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/hasOfferCatalog", Text.of(value));
        }

        @Override
        public Service.Builder addHoursAvailable(OpeningHoursSpecification value) {
            return (Service.Builder)this.addProperty("http://schema.org/hoursAvailable", value);
        }

        @Override
        public Service.Builder addHoursAvailable(OpeningHoursSpecification.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/hoursAvailable", value.build());
        }

        @Override
        public Service.Builder addHoursAvailable(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/hoursAvailable", Text.of(value));
        }

        @Override
        public Service.Builder addImage(ImageObject value) {
            return (Service.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Service.Builder addImage(ImageObject.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Service.Builder addImage(URL value) {
            return (Service.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Service.Builder addImage(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Service.Builder addMainEntityOfPage(CreativeWork value) {
            return (Service.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Service.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Service.Builder addMainEntityOfPage(URL value) {
            return (Service.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Service.Builder addMainEntityOfPage(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Service.Builder addName(Text value) {
            return (Service.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Service.Builder addName(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Service.Builder addOffers(Offer value) {
            return (Service.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Service.Builder addOffers(Offer.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Service.Builder addOffers(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Service.Builder addPotentialAction(Action value) {
            return (Service.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Service.Builder addPotentialAction(Action.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Service.Builder addPotentialAction(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Service.Builder addProduces(Thing value) {
            return (Service.Builder)this.addProperty("http://schema.org/produces", value);
        }

        @Override
        public Service.Builder addProduces(Thing.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/produces", value.build());
        }

        @Override
        public Service.Builder addProduces(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/produces", Text.of(value));
        }

        @Override
        public Service.Builder addProvider(Organization value) {
            return (Service.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Service.Builder addProvider(Organization.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Service.Builder addProvider(Person value) {
            return (Service.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Service.Builder addProvider(Person.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Service.Builder addProvider(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Service.Builder addProviderMobility(Text value) {
            return (Service.Builder)this.addProperty("http://schema.org/providerMobility", value);
        }

        @Override
        public Service.Builder addProviderMobility(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/providerMobility", Text.of(value));
        }

        @Override
        public Service.Builder addReview(Review value) {
            return (Service.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Service.Builder addReview(Review.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Service.Builder addReview(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Service.Builder addSameAs(URL value) {
            return (Service.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Service.Builder addSameAs(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Service.Builder addServiceArea(AdministrativeArea value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceArea", value);
        }

        @Override
        public Service.Builder addServiceArea(AdministrativeArea.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceArea", value.build());
        }

        @Override
        public Service.Builder addServiceArea(GeoShape value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceArea", value);
        }

        @Override
        public Service.Builder addServiceArea(GeoShape.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceArea", value.build());
        }

        @Override
        public Service.Builder addServiceArea(Place value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceArea", value);
        }

        @Override
        public Service.Builder addServiceArea(Place.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceArea", value.build());
        }

        @Override
        public Service.Builder addServiceArea(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceArea", Text.of(value));
        }

        @Override
        public Service.Builder addServiceAudience(Audience value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceAudience", value);
        }

        @Override
        public Service.Builder addServiceAudience(Audience.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceAudience", value.build());
        }

        @Override
        public Service.Builder addServiceAudience(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceAudience", Text.of(value));
        }

        @Override
        public Service.Builder addServiceOutput(Thing value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceOutput", value);
        }

        @Override
        public Service.Builder addServiceOutput(Thing.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceOutput", value.build());
        }

        @Override
        public Service.Builder addServiceOutput(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceOutput", Text.of(value));
        }

        @Override
        public Service.Builder addServiceType(Text value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceType", value);
        }

        @Override
        public Service.Builder addServiceType(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/serviceType", Text.of(value));
        }

        @Override
        public Service.Builder addUrl(URL value) {
            return (Service.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Service.Builder addUrl(String value) {
            return (Service.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Service.Builder addDetailedDescription(Article value) {
            return (Service.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Service.Builder addDetailedDescription(Article.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Service.Builder addDetailedDescription(String value) {
            return (Service.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Service.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Service.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Service.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Service.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Service.Builder addPopularityScore(String value) {
            return (Service.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Service build() {
            return new ServiceImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

