/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.StructuredValue;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class StructuredValueImpl
extends IntangibleImpl
implements StructuredValue {
    private static final ImmutableSet<String> PROPERTY_SET = StructuredValueImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public StructuredValueImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/StructuredValue";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<StructuredValue.Builder>
    implements StructuredValue.Builder {
        BuilderImpl() {
        }

        @Override
        public StructuredValue.Builder addAdditionalType(URL value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public StructuredValue.Builder addAdditionalType(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public StructuredValue.Builder addAlternateName(Text value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public StructuredValue.Builder addAlternateName(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public StructuredValue.Builder addDescription(Text value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public StructuredValue.Builder addDescription(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public StructuredValue.Builder addImage(ImageObject value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public StructuredValue.Builder addImage(ImageObject.Builder value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public StructuredValue.Builder addImage(URL value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public StructuredValue.Builder addImage(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public StructuredValue.Builder addMainEntityOfPage(CreativeWork value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public StructuredValue.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public StructuredValue.Builder addMainEntityOfPage(URL value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public StructuredValue.Builder addMainEntityOfPage(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public StructuredValue.Builder addName(Text value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public StructuredValue.Builder addName(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public StructuredValue.Builder addPotentialAction(Action value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public StructuredValue.Builder addPotentialAction(Action.Builder value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public StructuredValue.Builder addPotentialAction(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public StructuredValue.Builder addSameAs(URL value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public StructuredValue.Builder addSameAs(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public StructuredValue.Builder addUrl(URL value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public StructuredValue.Builder addUrl(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public StructuredValue.Builder addDetailedDescription(Article value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public StructuredValue.Builder addDetailedDescription(Article.Builder value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public StructuredValue.Builder addDetailedDescription(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public StructuredValue.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public StructuredValue.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public StructuredValue.Builder addPopularityScore(String value) {
            return (StructuredValue.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public StructuredValue build() {
            return new StructuredValueImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

