/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.EventImpl;
import com.google.schemaorg.core.EventStatusType;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PostalAddress;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.TheaterEvent;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class TheaterEventImpl
extends EventImpl
implements TheaterEvent {
    private static final ImmutableSet<String> PROPERTY_SET = TheaterEventImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/attendee");
        builder.add((Object)"http://schema.org/attendees");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/doorTime");
        builder.add((Object)"http://schema.org/duration");
        builder.add((Object)"http://schema.org/endDate");
        builder.add((Object)"http://schema.org/eventStatus");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/location");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/organizer");
        builder.add((Object)"http://schema.org/performer");
        builder.add((Object)"http://schema.org/performers");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/previousStartDate");
        builder.add((Object)"http://schema.org/recordedIn");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/startDate");
        builder.add((Object)"http://schema.org/subEvent");
        builder.add((Object)"http://schema.org/subEvents");
        builder.add((Object)"http://schema.org/superEvent");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/workFeatured");
        builder.add((Object)"http://schema.org/workPerformed");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public TheaterEventImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/TheaterEvent";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<TheaterEvent.Builder>
    implements TheaterEvent.Builder {
        BuilderImpl() {
        }

        @Override
        public TheaterEvent.Builder addAdditionalType(URL value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public TheaterEvent.Builder addAdditionalType(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addAggregateRating(AggregateRating value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public TheaterEvent.Builder addAggregateRating(AggregateRating.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public TheaterEvent.Builder addAggregateRating(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addAlternateName(Text value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public TheaterEvent.Builder addAlternateName(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addAttendee(Organization value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/attendee", value);
        }

        @Override
        public TheaterEvent.Builder addAttendee(Organization.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/attendee", value.build());
        }

        @Override
        public TheaterEvent.Builder addAttendee(Person value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/attendee", value);
        }

        @Override
        public TheaterEvent.Builder addAttendee(Person.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/attendee", value.build());
        }

        @Override
        public TheaterEvent.Builder addAttendee(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/attendee", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addAttendees(Organization value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/attendees", value);
        }

        @Override
        public TheaterEvent.Builder addAttendees(Organization.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/attendees", value.build());
        }

        @Override
        public TheaterEvent.Builder addAttendees(Person value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/attendees", value);
        }

        @Override
        public TheaterEvent.Builder addAttendees(Person.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/attendees", value.build());
        }

        @Override
        public TheaterEvent.Builder addAttendees(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/attendees", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addDescription(Text value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public TheaterEvent.Builder addDescription(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addDoorTime(DateTime value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/doorTime", value);
        }

        @Override
        public TheaterEvent.Builder addDoorTime(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/doorTime", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addDuration(Duration value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/duration", value);
        }

        @Override
        public TheaterEvent.Builder addDuration(Duration.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/duration", value.build());
        }

        @Override
        public TheaterEvent.Builder addDuration(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/duration", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addEndDate(Date value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/endDate", value);
        }

        @Override
        public TheaterEvent.Builder addEndDate(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/endDate", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addEventStatus(EventStatusType value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/eventStatus", value);
        }

        @Override
        public TheaterEvent.Builder addEventStatus(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/eventStatus", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addImage(ImageObject value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public TheaterEvent.Builder addImage(ImageObject.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public TheaterEvent.Builder addImage(URL value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public TheaterEvent.Builder addImage(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addInLanguage(Language value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public TheaterEvent.Builder addInLanguage(Language.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public TheaterEvent.Builder addInLanguage(Text value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public TheaterEvent.Builder addInLanguage(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addLocation(Place value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public TheaterEvent.Builder addLocation(Place.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/location", value.build());
        }

        @Override
        public TheaterEvent.Builder addLocation(PostalAddress value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public TheaterEvent.Builder addLocation(PostalAddress.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/location", value.build());
        }

        @Override
        public TheaterEvent.Builder addLocation(Text value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public TheaterEvent.Builder addLocation(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/location", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addMainEntityOfPage(CreativeWork value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public TheaterEvent.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public TheaterEvent.Builder addMainEntityOfPage(URL value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public TheaterEvent.Builder addMainEntityOfPage(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addName(Text value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public TheaterEvent.Builder addName(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addOffers(Offer value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public TheaterEvent.Builder addOffers(Offer.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public TheaterEvent.Builder addOffers(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addOrganizer(Organization value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/organizer", value);
        }

        @Override
        public TheaterEvent.Builder addOrganizer(Organization.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/organizer", value.build());
        }

        @Override
        public TheaterEvent.Builder addOrganizer(Person value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/organizer", value);
        }

        @Override
        public TheaterEvent.Builder addOrganizer(Person.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/organizer", value.build());
        }

        @Override
        public TheaterEvent.Builder addOrganizer(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/organizer", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addPerformer(Organization value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/performer", value);
        }

        @Override
        public TheaterEvent.Builder addPerformer(Organization.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/performer", value.build());
        }

        @Override
        public TheaterEvent.Builder addPerformer(Person value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/performer", value);
        }

        @Override
        public TheaterEvent.Builder addPerformer(Person.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/performer", value.build());
        }

        @Override
        public TheaterEvent.Builder addPerformer(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/performer", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addPerformers(Organization value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/performers", value);
        }

        @Override
        public TheaterEvent.Builder addPerformers(Organization.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/performers", value.build());
        }

        @Override
        public TheaterEvent.Builder addPerformers(Person value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/performers", value);
        }

        @Override
        public TheaterEvent.Builder addPerformers(Person.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/performers", value.build());
        }

        @Override
        public TheaterEvent.Builder addPerformers(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/performers", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addPotentialAction(Action value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public TheaterEvent.Builder addPotentialAction(Action.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public TheaterEvent.Builder addPotentialAction(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addPreviousStartDate(Date value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/previousStartDate", value);
        }

        @Override
        public TheaterEvent.Builder addPreviousStartDate(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/previousStartDate", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addRecordedIn(CreativeWork value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/recordedIn", value);
        }

        @Override
        public TheaterEvent.Builder addRecordedIn(CreativeWork.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/recordedIn", value.build());
        }

        @Override
        public TheaterEvent.Builder addRecordedIn(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/recordedIn", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addReview(Review value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public TheaterEvent.Builder addReview(Review.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public TheaterEvent.Builder addReview(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addSameAs(URL value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public TheaterEvent.Builder addSameAs(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addStartDate(Date value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/startDate", value);
        }

        @Override
        public TheaterEvent.Builder addStartDate(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/startDate", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addSubEvent(Event value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/subEvent", value);
        }

        @Override
        public TheaterEvent.Builder addSubEvent(Event.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/subEvent", value.build());
        }

        @Override
        public TheaterEvent.Builder addSubEvent(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/subEvent", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addSubEvents(Event value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/subEvents", value);
        }

        @Override
        public TheaterEvent.Builder addSubEvents(Event.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/subEvents", value.build());
        }

        @Override
        public TheaterEvent.Builder addSubEvents(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/subEvents", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addSuperEvent(Event value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/superEvent", value);
        }

        @Override
        public TheaterEvent.Builder addSuperEvent(Event.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/superEvent", value.build());
        }

        @Override
        public TheaterEvent.Builder addSuperEvent(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/superEvent", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addTypicalAgeRange(Text value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public TheaterEvent.Builder addTypicalAgeRange(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addUrl(URL value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public TheaterEvent.Builder addUrl(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addWorkFeatured(CreativeWork value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/workFeatured", value);
        }

        @Override
        public TheaterEvent.Builder addWorkFeatured(CreativeWork.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/workFeatured", value.build());
        }

        @Override
        public TheaterEvent.Builder addWorkFeatured(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/workFeatured", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addWorkPerformed(CreativeWork value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/workPerformed", value);
        }

        @Override
        public TheaterEvent.Builder addWorkPerformed(CreativeWork.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/workPerformed", value.build());
        }

        @Override
        public TheaterEvent.Builder addWorkPerformed(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.org/workPerformed", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addDetailedDescription(Article value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public TheaterEvent.Builder addDetailedDescription(Article.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public TheaterEvent.Builder addDetailedDescription(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public TheaterEvent.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public TheaterEvent.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public TheaterEvent.Builder addPopularityScore(String value) {
            return (TheaterEvent.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public TheaterEvent build() {
            return new TheaterEventImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

