/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.TrainStation;
import com.google.schemaorg.core.TrainTrip;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class TrainTripImpl
extends IntangibleImpl
implements TrainTrip {
    private static final ImmutableSet<String> PROPERTY_SET = TrainTripImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/arrivalPlatform");
        builder.add((Object)"http://schema.org/arrivalStation");
        builder.add((Object)"http://schema.org/arrivalTime");
        builder.add((Object)"http://schema.org/departurePlatform");
        builder.add((Object)"http://schema.org/departureStation");
        builder.add((Object)"http://schema.org/departureTime");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/trainName");
        builder.add((Object)"http://schema.org/trainNumber");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public TrainTripImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/TrainTrip";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getArrivalPlatformList() {
        return this.getProperty("http://schema.org/arrivalPlatform");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArrivalStationList() {
        return this.getProperty("http://schema.org/arrivalStation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArrivalTimeList() {
        return this.getProperty("http://schema.org/arrivalTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDeparturePlatformList() {
        return this.getProperty("http://schema.org/departurePlatform");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDepartureStationList() {
        return this.getProperty("http://schema.org/departureStation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDepartureTimeList() {
        return this.getProperty("http://schema.org/departureTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProviderList() {
        return this.getProperty("http://schema.org/provider");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTrainNameList() {
        return this.getProperty("http://schema.org/trainName");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTrainNumberList() {
        return this.getProperty("http://schema.org/trainNumber");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<TrainTrip.Builder>
    implements TrainTrip.Builder {
        BuilderImpl() {
        }

        @Override
        public TrainTrip.Builder addAdditionalType(URL value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public TrainTrip.Builder addAdditionalType(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addAlternateName(Text value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public TrainTrip.Builder addAlternateName(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addArrivalPlatform(Text value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/arrivalPlatform", value);
        }

        @Override
        public TrainTrip.Builder addArrivalPlatform(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/arrivalPlatform", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addArrivalStation(TrainStation value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/arrivalStation", value);
        }

        @Override
        public TrainTrip.Builder addArrivalStation(TrainStation.Builder value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/arrivalStation", value.build());
        }

        @Override
        public TrainTrip.Builder addArrivalStation(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/arrivalStation", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addArrivalTime(DateTime value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/arrivalTime", value);
        }

        @Override
        public TrainTrip.Builder addArrivalTime(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/arrivalTime", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addDeparturePlatform(Text value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/departurePlatform", value);
        }

        @Override
        public TrainTrip.Builder addDeparturePlatform(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/departurePlatform", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addDepartureStation(TrainStation value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/departureStation", value);
        }

        @Override
        public TrainTrip.Builder addDepartureStation(TrainStation.Builder value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/departureStation", value.build());
        }

        @Override
        public TrainTrip.Builder addDepartureStation(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/departureStation", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addDepartureTime(DateTime value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/departureTime", value);
        }

        @Override
        public TrainTrip.Builder addDepartureTime(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/departureTime", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addDescription(Text value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public TrainTrip.Builder addDescription(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addImage(ImageObject value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public TrainTrip.Builder addImage(ImageObject.Builder value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public TrainTrip.Builder addImage(URL value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public TrainTrip.Builder addImage(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addMainEntityOfPage(CreativeWork value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public TrainTrip.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public TrainTrip.Builder addMainEntityOfPage(URL value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public TrainTrip.Builder addMainEntityOfPage(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addName(Text value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public TrainTrip.Builder addName(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addPotentialAction(Action value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public TrainTrip.Builder addPotentialAction(Action.Builder value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public TrainTrip.Builder addPotentialAction(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addProvider(Organization value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public TrainTrip.Builder addProvider(Organization.Builder value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public TrainTrip.Builder addProvider(Person value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public TrainTrip.Builder addProvider(Person.Builder value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public TrainTrip.Builder addProvider(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addSameAs(URL value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public TrainTrip.Builder addSameAs(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addTrainName(Text value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/trainName", value);
        }

        @Override
        public TrainTrip.Builder addTrainName(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/trainName", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addTrainNumber(Text value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/trainNumber", value);
        }

        @Override
        public TrainTrip.Builder addTrainNumber(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/trainNumber", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addUrl(URL value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public TrainTrip.Builder addUrl(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addDetailedDescription(Article value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public TrainTrip.Builder addDetailedDescription(Article.Builder value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public TrainTrip.Builder addDetailedDescription(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public TrainTrip.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public TrainTrip.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public TrainTrip.Builder addPopularityScore(String value) {
            return (TrainTrip.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public TrainTrip build() {
            return new TrainTripImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

