/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AnatomicalStructure;
import com.google.schemaorg.core.AnatomicalSystem;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.Vein;
import com.google.schemaorg.core.Vessel;
import com.google.schemaorg.core.VesselImpl;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class VeinImpl
extends VesselImpl
implements Vein {
    private static final ImmutableSet<String> PROPERTY_SET = VeinImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/associatedPathophysiology");
        builder.add((Object)"http://schema.org/bodyLocation");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/connectedTo");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/diagram");
        builder.add((Object)"http://schema.org/drainsTo");
        builder.add((Object)"http://schema.org/function");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/partOfSystem");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/regionDrained");
        builder.add((Object)"http://schema.org/relatedCondition");
        builder.add((Object)"http://schema.org/relatedTherapy");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/subStructure");
        builder.add((Object)"http://schema.org/tributary");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public VeinImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Vein";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDrainsToList() {
        return this.getProperty("http://schema.org/drainsTo");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRegionDrainedList() {
        return this.getProperty("http://schema.org/regionDrained");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTributaryList() {
        return this.getProperty("http://schema.org/tributary");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Vein.Builder>
    implements Vein.Builder {
        BuilderImpl() {
        }

        @Override
        public Vein.Builder addAdditionalType(URL value) {
            return (Vein.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Vein.Builder addAdditionalType(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Vein.Builder addAlternateName(Text value) {
            return (Vein.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Vein.Builder addAlternateName(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Vein.Builder addAssociatedPathophysiology(Text value) {
            return (Vein.Builder)this.addProperty("http://schema.org/associatedPathophysiology", value);
        }

        @Override
        public Vein.Builder addAssociatedPathophysiology(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/associatedPathophysiology", Text.of(value));
        }

        @Override
        public Vein.Builder addBodyLocation(Text value) {
            return (Vein.Builder)this.addProperty("http://schema.org/bodyLocation", value);
        }

        @Override
        public Vein.Builder addBodyLocation(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/bodyLocation", Text.of(value));
        }

        @Override
        public Vein.Builder addCode(MedicalCode value) {
            return (Vein.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public Vein.Builder addCode(MedicalCode.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public Vein.Builder addCode(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public Vein.Builder addConnectedTo(AnatomicalStructure value) {
            return (Vein.Builder)this.addProperty("http://schema.org/connectedTo", value);
        }

        @Override
        public Vein.Builder addConnectedTo(AnatomicalStructure.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/connectedTo", value.build());
        }

        @Override
        public Vein.Builder addConnectedTo(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/connectedTo", Text.of(value));
        }

        @Override
        public Vein.Builder addDescription(Text value) {
            return (Vein.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Vein.Builder addDescription(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Vein.Builder addDiagram(ImageObject value) {
            return (Vein.Builder)this.addProperty("http://schema.org/diagram", value);
        }

        @Override
        public Vein.Builder addDiagram(ImageObject.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/diagram", value.build());
        }

        @Override
        public Vein.Builder addDiagram(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/diagram", Text.of(value));
        }

        @Override
        public Vein.Builder addDrainsTo(Vessel value) {
            return (Vein.Builder)this.addProperty("http://schema.org/drainsTo", value);
        }

        @Override
        public Vein.Builder addDrainsTo(Vessel.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/drainsTo", value.build());
        }

        @Override
        public Vein.Builder addDrainsTo(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/drainsTo", Text.of(value));
        }

        @Override
        public Vein.Builder addFunction(Text value) {
            return (Vein.Builder)this.addProperty("http://schema.org/function", value);
        }

        @Override
        public Vein.Builder addFunction(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/function", Text.of(value));
        }

        @Override
        public Vein.Builder addGuideline(MedicalGuideline value) {
            return (Vein.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public Vein.Builder addGuideline(MedicalGuideline.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public Vein.Builder addGuideline(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public Vein.Builder addImage(ImageObject value) {
            return (Vein.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Vein.Builder addImage(ImageObject.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Vein.Builder addImage(URL value) {
            return (Vein.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Vein.Builder addImage(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Vein.Builder addMainEntityOfPage(CreativeWork value) {
            return (Vein.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Vein.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Vein.Builder addMainEntityOfPage(URL value) {
            return (Vein.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Vein.Builder addMainEntityOfPage(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Vein.Builder addMedicineSystem(MedicineSystem value) {
            return (Vein.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public Vein.Builder addMedicineSystem(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public Vein.Builder addName(Text value) {
            return (Vein.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Vein.Builder addName(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Vein.Builder addPartOfSystem(AnatomicalSystem value) {
            return (Vein.Builder)this.addProperty("http://schema.org/partOfSystem", value);
        }

        @Override
        public Vein.Builder addPartOfSystem(AnatomicalSystem.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/partOfSystem", value.build());
        }

        @Override
        public Vein.Builder addPartOfSystem(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/partOfSystem", Text.of(value));
        }

        @Override
        public Vein.Builder addPotentialAction(Action value) {
            return (Vein.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Vein.Builder addPotentialAction(Action.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Vein.Builder addPotentialAction(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Vein.Builder addRecognizingAuthority(Organization value) {
            return (Vein.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public Vein.Builder addRecognizingAuthority(Organization.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public Vein.Builder addRecognizingAuthority(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public Vein.Builder addRegionDrained(AnatomicalStructure value) {
            return (Vein.Builder)this.addProperty("http://schema.org/regionDrained", value);
        }

        @Override
        public Vein.Builder addRegionDrained(AnatomicalStructure.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/regionDrained", value.build());
        }

        @Override
        public Vein.Builder addRegionDrained(AnatomicalSystem value) {
            return (Vein.Builder)this.addProperty("http://schema.org/regionDrained", value);
        }

        @Override
        public Vein.Builder addRegionDrained(AnatomicalSystem.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/regionDrained", value.build());
        }

        @Override
        public Vein.Builder addRegionDrained(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/regionDrained", Text.of(value));
        }

        @Override
        public Vein.Builder addRelatedCondition(MedicalCondition value) {
            return (Vein.Builder)this.addProperty("http://schema.org/relatedCondition", value);
        }

        @Override
        public Vein.Builder addRelatedCondition(MedicalCondition.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/relatedCondition", value.build());
        }

        @Override
        public Vein.Builder addRelatedCondition(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/relatedCondition", Text.of(value));
        }

        @Override
        public Vein.Builder addRelatedTherapy(MedicalTherapy value) {
            return (Vein.Builder)this.addProperty("http://schema.org/relatedTherapy", value);
        }

        @Override
        public Vein.Builder addRelatedTherapy(MedicalTherapy.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/relatedTherapy", value.build());
        }

        @Override
        public Vein.Builder addRelatedTherapy(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/relatedTherapy", Text.of(value));
        }

        @Override
        public Vein.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (Vein.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public Vein.Builder addRelevantSpecialty(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public Vein.Builder addSameAs(URL value) {
            return (Vein.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Vein.Builder addSameAs(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Vein.Builder addStudy(MedicalStudy value) {
            return (Vein.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public Vein.Builder addStudy(MedicalStudy.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public Vein.Builder addStudy(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public Vein.Builder addSubStructure(AnatomicalStructure value) {
            return (Vein.Builder)this.addProperty("http://schema.org/subStructure", value);
        }

        @Override
        public Vein.Builder addSubStructure(AnatomicalStructure.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/subStructure", value.build());
        }

        @Override
        public Vein.Builder addSubStructure(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/subStructure", Text.of(value));
        }

        @Override
        public Vein.Builder addTributary(AnatomicalStructure value) {
            return (Vein.Builder)this.addProperty("http://schema.org/tributary", value);
        }

        @Override
        public Vein.Builder addTributary(AnatomicalStructure.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.org/tributary", value.build());
        }

        @Override
        public Vein.Builder addTributary(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/tributary", Text.of(value));
        }

        @Override
        public Vein.Builder addUrl(URL value) {
            return (Vein.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Vein.Builder addUrl(String value) {
            return (Vein.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Vein.Builder addDetailedDescription(Article value) {
            return (Vein.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Vein.Builder addDetailedDescription(Article.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Vein.Builder addDetailedDescription(String value) {
            return (Vein.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Vein.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Vein.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Vein.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Vein.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Vein.Builder addPopularityScore(String value) {
            return (Vein.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Vein build() {
            return new VeinImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

