/*
 * Decompiled with CFR 0.152.
 */
package de.mrapp.util.datastructure;

import de.mrapp.util.Condition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortedArrayList<T>
extends ArrayList<T> {
    private final Comparator<? super T> comparator;

    public SortedArrayList() {
        this((Comparator)null);
    }

    public SortedArrayList(@NotNull Collection<? extends T> items) {
        this((Comparator)null);
        this.addAll(items);
    }

    public SortedArrayList(int initialCapacity) {
        this(initialCapacity, null);
    }

    public SortedArrayList(@Nullable Comparator<? super T> comparator) {
        this.comparator = comparator;
    }

    public SortedArrayList(@NotNull Collection<? extends T> items, @Nullable Comparator<? super T> comparator) {
        this(comparator);
        this.addAll(items);
    }

    public SortedArrayList(int initialCapacity, @Nullable Comparator<? super T> comparator) {
        super(initialCapacity);
        this.comparator = comparator;
    }

    @Nullable
    public Comparator<? super T> comparator() {
        return this.comparator;
    }

    @Override
    public final boolean add(@NotNull T item) {
        Condition.ensureNotNull(item, "The item may not be null");
        int index = Collections.binarySearch(this, item, this.comparator);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        }
        super.add(index, item);
        return true;
    }

    @Override
    public final void add(int index, @NotNull T item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(@NotNull Collection<? extends T> items) {
        Condition.ensureNotNull(items, "The collection may not be null");
        if (items.size() > 0) {
            items.forEach(this::add);
            return true;
        }
        return false;
    }

    @Override
    public final boolean addAll(int index, @NotNull Collection<? extends T> items) {
        throw new UnsupportedOperationException();
    }
}

