/*
 * Decompiled with CFR 0.152.
 */
package de.mrapp.util.datastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0015\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0019\b\u0016\u0012\u0010\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB'\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0010\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rB\u001f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0016\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0010\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u000bR\u0018\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/mrapp/util/datastructure/SortedArrayList;", "T", "Ljava/util/ArrayList;", "()V", "items", "", "(Ljava/util/Collection;)V", "initialCapacity", "", "(I)V", "comparator", "Ljava/util/Comparator;", "(Ljava/util/Comparator;)V", "(Ljava/util/Collection;Ljava/util/Comparator;)V", "(ILjava/util/Comparator;)V", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "JavaUtil"})
public final class SortedArrayList<T>
extends ArrayList<T> {
    private final int initialCapacity;
    private final Comparator<? super T> comparator;

    @Nullable
    public final Comparator<? super T> comparator() {
        return this.comparator;
    }

    @Override
    public boolean add(T element) {
        int index = Collections.binarySearch(this, element, this.comparator);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        }
        super.add(index, element);
        return true;
    }

    @Override
    public void add(int index, T element) {
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Collection<T> collection = elements;
        if (!collection.isEmpty()) {
            Iterable $receiver$iv = elements;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                this.add((T)it);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        throw (Throwable)new UnsupportedOperationException();
    }

    public SortedArrayList(int initialCapacity, @Nullable Comparator<? super T> comparator) {
        super(initialCapacity);
        this.initialCapacity = initialCapacity;
        this.comparator = comparator;
    }

    public SortedArrayList() {
        this(0, null);
    }

    public SortedArrayList(@NotNull Collection<? extends T> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this(0, null);
        this.addAll(items);
    }

    public SortedArrayList(int initialCapacity) {
        this(initialCapacity, null);
    }

    public SortedArrayList(@Nullable Comparator<? super T> comparator) {
        this(0, comparator);
    }

    public SortedArrayList(@NotNull Collection<? extends T> items, @Nullable Comparator<? super T> comparator) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this(0, comparator);
        this.addAll(items);
    }
}

