/*
 * Decompiled with CFR 0.152.
 */
package de.mrapp.util.datastructure;

import de.mrapp.util.Condition;
import de.mrapp.util.datastructure.SortedArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010)\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0015\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0019\b\u0016\u0012\u0010\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB'\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0010\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rB\u001f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u000bH\u0016J\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010 \u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0013\u0010!\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\r\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\bH\u0016J\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010(\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u0018H\u0016J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0096\u0002J\r\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\u0015\u0010.\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010/\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0016\u00100\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J#\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u00102\u001a\u00028\u00002\u0006\u0010(\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00103J\u001b\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u00102\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\b\u00105\u001a\u000206H\u0016R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0010j\b\u0012\u0004\u0012\u00020\b`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lde/mrapp/util/datastructure/SortedArraySet;", "T", "Ljava/util/SortedSet;", "()V", "items", "", "(Ljava/util/Collection;)V", "initialCapacity", "", "(I)V", "comparator", "Ljava/util/Comparator;", "(Ljava/util/Comparator;)V", "(Ljava/util/Collection;Ljava/util/Comparator;)V", "(ILjava/util/Comparator;)V", "hashCodes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "size", "getSize", "()I", "sortedArrayList", "Lde/mrapp/util/datastructure/SortedArrayList;", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "clear", "", "contains", "containsAll", "equals", "other", "", "first", "()Ljava/lang/Object;", "hashCode", "headSet", "toElement", "(Ljava/lang/Object;)Ljava/util/SortedSet;", "isEmpty", "iterator", "", "last", "remove", "removeAll", "retainAll", "subSet", "fromElement", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/SortedSet;", "tailSet", "toString", "", "JavaUtil"})
public class SortedArraySet<T>
implements SortedSet<T> {
    private final SortedArrayList<T> sortedArrayList;
    private final HashSet<Integer> hashCodes;

    @Override
    @Nullable
    public Comparator<? super T> comparator() {
        return this.sortedArrayList.comparator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SortedSet<T> subSet(T fromElement, T toElement) {
        int start = this.sortedArrayList.indexOf(fromElement);
        Condition.INSTANCE.ensureNotEqual(start, -1, "fromElement not contained by set", NoSuchElementException.class);
        int end = this.sortedArrayList.indexOf(toElement);
        Condition.INSTANCE.ensureNotEqual(end, -1, "toElement not contained by set", NoSuchElementException.class);
        Condition.INSTANCE.ensureFalse(start > end, "fromElement greater than toElement");
        SortedArraySet subSet = new SortedArraySet(end - start + 1);
        int n = start;
        int n2 = end;
        if (n <= n2) {
            while (true) {
                void i;
                subSet.add((T)this.sortedArrayList.get((int)i));
                if (i == n2) break;
                ++i;
            }
        }
        return subSet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SortedSet<T> headSet(T toElement) {
        int end = this.sortedArrayList.indexOf(toElement);
        Condition.INSTANCE.ensureNotEqual(end, -1, "toElement not contained by set", NoSuchElementException.class);
        SortedArraySet headSet = new SortedArraySet(end + 1);
        int n = 0;
        int n2 = end;
        if (n <= n2) {
            while (true) {
                void i;
                headSet.add((T)this.sortedArrayList.get((int)i));
                if (i == n2) break;
                ++i;
            }
        }
        return headSet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SortedSet<T> tailSet(T fromElement) {
        int start = this.sortedArrayList.indexOf(fromElement);
        Condition.INSTANCE.ensureNotEqual(start, -1, "fromElement not contained by set", NoSuchElementException.class);
        SortedArraySet tailSet = new SortedArraySet(this.size() - start);
        int n = start;
        int n2 = this.size();
        while (n < n2) {
            void i;
            tailSet.add((T)this.sortedArrayList.get((int)i));
            ++i;
        }
        return tailSet;
    }

    @Override
    public T first() {
        Condition.INSTANCE.ensureFalse(this.isEmpty(), "Set is empty", NoSuchElementException.class);
        return (T)this.sortedArrayList.get(0);
    }

    @Override
    public T last() {
        Condition.INSTANCE.ensureFalse(this.isEmpty(), "Set is empty", NoSuchElementException.class);
        return (T)this.sortedArrayList.get(this.sortedArrayList.size() - 1);
    }

    public int getSize() {
        return this.sortedArrayList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sortedArrayList.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return this.sortedArrayList.contains(element);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator iterator = this.sortedArrayList.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"sortedArrayList.iterator()");
        return iterator;
    }

    @Override
    public boolean add(T element) {
        int hashCode;
        Condition.INSTANCE.ensureNotNull(element, "The item may not be null");
        T t = element;
        if (t == null) {
            Intrinsics.throwNpe();
        }
        if (!this.hashCodes.contains(hashCode = t.hashCode())) {
            this.sortedArrayList.add(element);
            this.hashCodes.add(hashCode);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object element) {
        int hashCode;
        Condition.INSTANCE.ensureNotNull(element, "The item may not be null");
        Object object = element;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if (this.hashCodes.remove(hashCode = object.hashCode())) {
            this.sortedArrayList.remove(element);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Iterable iterable = $receiver$iv = (Iterable)elements;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            Boolean bl = this.contains(it);
            collection.add(bl);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            boolean bl = (Boolean)iterator$iv.next();
            boolean acc = (Boolean)accumulator$iv;
            accumulator$iv = acc && b != false;
        }
        return (Boolean)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        void var4_6;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        if (elements.isEmpty()) return false;
        Iterable iterable = $receiver$iv = (Iterable)elements;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection2 = collection;
            Boolean bl = this.add(it);
            collection2.add(bl);
        }
        $receiver$iv = (List)collection;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object t = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            boolean bl = (Boolean)iterator$iv.next();
            boolean acc = (Boolean)var4_6;
            Boolean bl2 = acc && b != false;
        }
        if ((Boolean)var4_6 == false) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        if (!elements.isEmpty()) {
            boolean result = false;
            int n = this.size() - 1;
            boolean bl = false;
            while (n >= 0) {
                void i;
                Object item = this.sortedArrayList.get((int)i);
                if (item != null && !elements.contains(item)) {
                    int hashCode = item.hashCode();
                    this.sortedArrayList.remove((int)i);
                    this.hashCodes.remove(hashCode);
                    result = true;
                }
                --i;
            }
            return result;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        void var4_6;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        if (elements.isEmpty()) return false;
        Iterable iterable = $receiver$iv = (Iterable)elements;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection2 = collection;
            Boolean bl = this.remove(it);
            collection2.add(bl);
        }
        $receiver$iv = (List)collection;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object t = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            boolean bl = (Boolean)iterator$iv.next();
            boolean acc = (Boolean)var4_6;
            Boolean bl2 = acc && b != false;
        }
        if ((Boolean)var4_6 == false) return false;
        return true;
    }

    @Override
    public void clear() {
        this.hashCodes.clear();
        this.sortedArrayList.clear();
    }

    @NotNull
    public String toString() {
        String string = this.sortedArrayList.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sortedArrayList.toString()");
        return string;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.hashCodes.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        SortedArraySet another = (SortedArraySet)other;
        return Intrinsics.areEqual(this.hashCodes, another.hashCodes);
    }

    public SortedArraySet(int initialCapacity, @Nullable Comparator<? super T> comparator) {
        this.sortedArrayList = new SortedArrayList<T>(initialCapacity, comparator);
        this.hashCodes = new HashSet(initialCapacity);
    }

    public SortedArraySet() {
        this(0, null);
    }

    public SortedArraySet(@NotNull Collection<? extends T> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this(0, null);
        this.addAll(items);
    }

    public SortedArraySet(int initialCapacity) {
        this(initialCapacity, null);
    }

    public SortedArraySet(@Nullable Comparator<? super T> comparator) {
        this(0, comparator);
    }

    public SortedArraySet(@NotNull Collection<? extends T> items, @Nullable Comparator<? super T> comparator) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this(0, comparator);
        this.addAll(items);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }
}

