/*
 * Decompiled with CFR 0.152.
 */
package de.mrapp.util.datastructure;

import de.mrapp.util.Condition;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B1\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0012\b\u0002\u0010\u0007\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\b\u0002\u0010\u0007\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/mrapp/util/datastructure/FixedPriorityQueue;", "T", "Ljava/util/PriorityQueue;", "maxSize", "", "items", "", "comparator", "Ljava/util/Comparator;", "(ILjava/util/Collection;Ljava/util/Comparator;)V", "(ILjava/util/Comparator;)V", "compare", "first", "second", "(Ljava/lang/Object;Ljava/lang/Object;)I", "offer", "", "e", "(Ljava/lang/Object;)Z", "JavaUtil"})
public final class FixedPriorityQueue<T>
extends PriorityQueue<T> {
    private final int maxSize;

    private final int compare(T first, T second) {
        int n;
        Comparator comparator = this.comparator();
        if (comparator != null) {
            n = comparator.compare(first, second);
        } else {
            T t = first;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Comparable<T>");
            }
            n = ((Comparable)t).compareTo(second);
        }
        return n;
    }

    @Override
    public boolean offer(T e) {
        if (this.size() >= this.maxSize) {
            Object first = this.peek();
            if (this.compare(e, first) > 0) {
                this.poll();
                return super.offer(e);
            }
            return false;
        }
        return super.offer(e);
    }

    @JvmOverloads
    public FixedPriorityQueue(int maxSize, @Nullable Comparator<? super T> comparator) {
        super(maxSize, comparator);
        this.maxSize = maxSize;
        Condition.INSTANCE.ensureAtLeast(this.maxSize, 1, "The maximum size must be at least 1");
    }

    public /* synthetic */ FixedPriorityQueue(int n, Comparator comparator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            comparator = null;
        }
        this(n, (Comparator<T>)comparator);
    }

    @JvmOverloads
    public FixedPriorityQueue(int maxSize) {
        this(maxSize, null, 2, null);
    }

    @JvmOverloads
    public FixedPriorityQueue(int maxSize, @NotNull Collection<? extends T> items, @Nullable Comparator<? super T> comparator) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this(maxSize, comparator);
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            this.offer((T)it);
        }
    }

    public /* synthetic */ FixedPriorityQueue(int n, Collection collection, Comparator comparator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            comparator = null;
        }
        this(n, collection, comparator);
    }

    @JvmOverloads
    public FixedPriorityQueue(int maxSize, @NotNull Collection<? extends T> items) {
        this(maxSize, items, null, 4, null);
    }
}

