/*
 * Decompiled with CFR 0.152.
 */
package com.mwt.explorers;

import com.mwt.explorers.EpsilonGreedyExplorer;
import com.mwt.explorers.Explorer;
import com.mwt.explorers.utilities.ExplorerInformation;
import com.mwt.explorers.utilities.FixedVariableActionContext;
import junit.framework.Assert;
import org.junit.Test;

public class EpsilonGreedyExplorerTest {
    private final ExplorerInformation<String> exInfo = new ExplorerInformation(8);
    private final ExplorerInformation<FixedVariableActionContext> varExInfo = new ExplorerInformation(8);

    @Test
    public void fixedPolicyLowEpsilon() {
        this.lowEpsilon("context", this.exInfo);
    }

    @Test
    public void fixedPolicyHighEpsilon() {
        this.highEpsilon("context", this.exInfo);
    }

    @Test
    public void variableActionLowEpsilon() {
        this.lowEpsilon(new FixedVariableActionContext(10), this.varExInfo);
    }

    @Test
    public void variableActionHighEpsilon() {
        this.highEpsilon(new FixedVariableActionContext(10), this.varExInfo);
    }

    private <T> void lowEpsilon(T context, ExplorerInformation<T> exInfo) {
        EpsilonGreedyExplorer explorer = new EpsilonGreedyExplorer(exInfo.policy, 0.1f, 10);
        int action = exInfo.mwt.chooseAction((Explorer)explorer, "abc", context);
        Assert.assertEquals((int)8, (int)action);
        Assert.assertEquals((String)("8 abc 0.91000 | " + context), (String)exInfo.recorder.getRecording().trim());
    }

    private <T> void highEpsilon(T context, ExplorerInformation<T> exInfo) {
        EpsilonGreedyExplorer explorer = new EpsilonGreedyExplorer(exInfo.policy, 0.9f, 10);
        int action = exInfo.mwt.chooseAction((Explorer)explorer, "abc", context);
        Assert.assertEquals((int)7, (int)action);
        Assert.assertEquals((String)("7 abc 0.09000 | " + context), (String)exInfo.recorder.getRecording().trim());
    }
}

