/*
 * Decompiled with CFR 0.152.
 */
package com.github.parze;

import com.github.parze.Queue;
import com.github.parze.QueueItem;
import com.github.parze.TdbqException;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.WriteResult;
import com.mongodb.client.MongoDatabase;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDbQueue<T>
extends Queue<T> {
    private Logger logger = LoggerFactory.getLogger(MongoDbQueue.class);
    private static String FIELD_CREATED_SEQUENCE = "created_sequence";
    private static String FIELD_STARTED_AT = "started_at";
    private static String FIELD_ITEM = "item";
    private static String COLLECTION_NAME_COUNTERS = "counters";
    private MongoDatabase mongoDatabase;
    private DB mongoDb;
    private DBCollection queueCollection;
    private DBCollection queueCounterCollection;
    private String counterName;

    protected MongoDbQueue(Class<T> clazzOfItem, MongoClient mongoClient, String databaseName, String queueName) {
        super(clazzOfItem, queueName);
        this.mongoDatabase = mongoClient.getDatabase(databaseName);
        this.mongoDb = mongoClient.getDB(databaseName);
        this.queueCollection = this.mongoDb.getCollection(queueName);
        this.queueCounterCollection = this.mongoDb.getCollection(COLLECTION_NAME_COUNTERS);
        this.counterName = queueName + "_counter";
    }

    public DBCollection getQueueCollection() {
        return this.queueCollection;
    }

    @Override
    public void addItem(T item) {
        BasicDBObject document = new BasicDBObject().append(FIELD_CREATED_SEQUENCE, (Object)this.getNextSequenceNumber()).append(FIELD_ITEM, (Object)this.toJson(item)).append(FIELD_STARTED_AT, null);
        this.queueCollection.insert(new DBObject[]{document});
        this.logger.info("Added item " + item.toString() + " to the queue.");
    }

    public Integer getNextSequenceNumber() {
        BasicDBObject query = new BasicDBObject("name", (Object)new BasicDBObject("$eq", (Object)this.counterName));
        BasicDBObject update = new BasicDBObject("$inc", (Object)new BasicDBObject("number", (Object)1));
        DBObject dbObject = this.queueCounterCollection.findAndModify((DBObject)query, null, null, false, (DBObject)update, true, true);
        return (Integer)dbObject.get("number");
    }

    @Override
    public long getQueueSize() {
        return this.queueCollection.find().count();
    }

    @Override
    public QueueItem<T> getAndLockNextItem() {
        String startedAt;
        BasicDBObject update;
        BasicDBObject query = new BasicDBObject(FIELD_STARTED_AT, (Object)new BasicDBObject("$eq", null));
        BasicDBObject sort = new BasicDBObject(FIELD_CREATED_SEQUENCE, (Object)1);
        DBObject queueItem = this.queueCollection.findAndModify((DBObject)query, null, (DBObject)sort, false, (DBObject)(update = new BasicDBObject("$set", (Object)new BasicDBObject(FIELD_STARTED_AT, (Object)(startedAt = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()))))), true, false);
        if (queueItem == null) {
            return null;
        }
        Integer id = (Integer)queueItem.get(FIELD_CREATED_SEQUENCE);
        Object item = this.fromJson(queueItem.get(FIELD_ITEM).toString());
        this.logger.info("Locked and retrieved item id:" + id + " = " + item.toString() + " from the queue.");
        return new QueueItem(new Long(id.intValue()), item);
    }

    @Override
    public void removeItem(QueueItem<T> queueItem) {
        BasicDBObject query = new BasicDBObject(FIELD_CREATED_SEQUENCE, (Object)queueItem.getId());
        WriteResult result = this.queueCollection.remove((DBObject)query);
        this.logger.info("Removed item id:" + queueItem.getId() + " = " + queueItem.getItem().toString() + " from the queue.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private MongoClient mongoClient;
        private String databaseName;
        private String queueName;
        private Class<T> clazzOfItem;

        public Builder withClassOfItem(Class<T> clazzOfItem) {
            this.clazzOfItem = clazzOfItem;
            return this;
        }

        public Builder withQueueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Builder<T> withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder<T> withMongoClient(MongoClient mongoClient) {
            this.mongoClient = mongoClient;
            return this;
        }

        public MongoDbQueue<T> build() {
            if (this.databaseName == null || this.mongoClient == null || this.clazzOfItem == null) {
                throw new TdbqException("Mongo client, database name, and class of item must be set.");
            }
            if (this.queueName == null) {
                this.queueName = "queue_" + this.clazzOfItem.getName().replace('.', '_').toLowerCase();
            }
            return new MongoDbQueue<T>(this.clazzOfItem, this.mongoClient, this.databaseName, this.queueName);
        }
    }
}

