/*
 * Decompiled with CFR 0.152.
 */
package com.github.parze;

import com.github.parze.QueueItem;
import com.github.parze.TdbqException;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Queue<T> {
    private Logger logger = LoggerFactory.getLogger(Queue.class);
    private String queueName;
    private Class<T> clazzOfItem;
    private ObjectMapper mapper = new ObjectMapper();

    protected Queue(Class<T> clazzOfItem, String queueName) {
        this.clazzOfItem = clazzOfItem;
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public abstract void addItem(T var1);

    protected String toJson(T item) {
        try {
            return this.mapper.writeValueAsString(item);
        }
        catch (IOException e) {
            throw new TdbqException("Failed to parse item to Json.", e);
        }
    }

    protected T fromJson(String str) {
        try {
            return (T)this.mapper.readValue(str, this.clazzOfItem);
        }
        catch (IOException e) {
            throw new TdbqException("Failed to parse item to Json.", e);
        }
    }

    public abstract long getQueueSize();

    public abstract QueueItem<T> getAndLockNextItem();

    public abstract void removeItem(QueueItem<T> var1);
}

