/*
 * Decompiled with CFR 0.152.
 */
package com.github.parze;

import com.github.parze.Queue;
import com.github.parze.QueueItem;
import com.github.parze.RelationalDatabaseType;
import com.github.parze.RelationalDatabaseTypeFactory;
import com.github.parze.TdbqException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalDatabaseQueue<T>
extends Queue<T> {
    private Logger logger = LoggerFactory.getLogger(RelationalDatabaseQueue.class);
    private PlatformTransactionManager platformTransactionManager;
    private int maxJsonLength;
    private RelationalDatabaseType relationalDatabaseType;
    private JdbcTemplate jdbcTemplate;

    protected RelationalDatabaseQueue(DataSource dataSource, PlatformTransactionManager platformTransactionManager, int maxJsonLength, Class<T> clazzOfItem, String queueName) {
        super(clazzOfItem, queueName);
        this.maxJsonLength = maxJsonLength;
        this.platformTransactionManager = platformTransactionManager;
        this.relationalDatabaseType = RelationalDatabaseTypeFactory.getDataBaseType(dataSource);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.createTableIfNotExists();
    }

    private TransactionStatus createTransactionStatus() {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        return this.platformTransactionManager.getTransaction((TransactionDefinition)transactionDefinition);
    }

    private void createTableIfNotExists() {
        TransactionStatus status = this.createTransactionStatus();
        this.jdbcTemplate.execute(this.relationalDatabaseType.getCreateQueueTableSql(this.getQueueTableName(), this.maxJsonLength));
        this.platformTransactionManager.commit(status);
    }

    public String getQueueTableName() {
        return this.getQueueName();
    }

    @Override
    public void addItem(T item) {
        TransactionStatus status = this.createTransactionStatus();
        this.jdbcTemplate.update("Insert Into " + this.getQueueTableName() + "(item, started_at) Values (?,?)", new Object[]{this.toJson(item), null});
        this.platformTransactionManager.commit(status);
    }

    @Override
    public long getQueueSize() {
        return (Long)this.jdbcTemplate.queryForMap("Select count(id) as c From " + this.getQueueTableName()).get("c");
    }

    @Override
    public QueueItem<T> getAndLockNextItem() {
        Long id = null;
        String itemStr = null;
        TransactionStatus status = this.createTransactionStatus();
        String sql = this.relationalDatabaseType.getSqlSelectForUpdate(this.getQueueTableName());
        List results = this.jdbcTemplate.queryForList(sql);
        if (results != null && results.size() > 0) {
            id = (Long)((Map)results.get(0)).get("id");
            sql = "Update " + this.getQueueTableName() + " Set started_at=? Where id=?";
            this.jdbcTemplate.update(sql, new Object[]{new Date(), id});
            Map result = this.jdbcTemplate.queryForMap("Select item From " + this.getQueueTableName() + " Where id=?", new Object[]{id});
            if (result != null && result.size() > 0) {
                itemStr = (String)result.get("item");
            }
        }
        this.platformTransactionManager.commit(status);
        if (id == null || itemStr == null) {
            return null;
        }
        return new QueueItem(id, this.fromJson(itemStr));
    }

    @Override
    public void removeItem(QueueItem<T> queueItem) {
        TransactionStatus status = this.createTransactionStatus();
        this.jdbcTemplate.update("Delete From " + this.getQueueTableName() + " Where id=?", new Object[]{queueItem.getId()});
        this.platformTransactionManager.commit(status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private DataSource dataSource;
        private PlatformTransactionManager platformTransactionManager;
        private Integer maxJsonLength;
        private Class<T> clazzOfItem;
        private String queueName;

        public Builder withDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder withPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
            this.platformTransactionManager = platformTransactionManager;
            return this;
        }

        public Builder withMaxJsonLength(Integer maxJsonLength) {
            this.maxJsonLength = maxJsonLength;
            return this;
        }

        public Builder withClassOfItem(Class<T> clazzOfItem) {
            this.clazzOfItem = clazzOfItem;
            return this;
        }

        public Builder withQueueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Queue<T> build() {
            if (this.dataSource == null || this.clazzOfItem == null) {
                throw new TdbqException("Data source and class of item must be set.");
            }
            if (this.maxJsonLength == null) {
                this.maxJsonLength = 128;
            }
            if (this.queueName == null) {
                this.queueName = "queue_" + this.clazzOfItem.getName().replace('.', '_').toLowerCase();
            }
            if (this.platformTransactionManager == null) {
                this.platformTransactionManager = new DataSourceTransactionManager(this.dataSource);
            }
            return new RelationalDatabaseQueue<T>(this.dataSource, this.platformTransactionManager, this.maxJsonLength, this.clazzOfItem, this.queueName);
        }
    }
}

