/*
 * Decompiled with CFR 0.152.
 */
package com.github.parze;

import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class RelationalDatabaseType {
    public abstract boolean dataSourceBelongToType(JdbcTemplate var1);

    public abstract String getCreateQueueTableSql(String var1, int var2);

    public abstract String getSqlSelectForUpdate(String var1);

    public static class PostgresSql
    extends MySql {
        public boolean dataSourceBelongToType(JdbcTemplate jdbcTemplate) {
            try {
                List result = jdbcTemplate.queryForList("SELECT version()");
                return result != null && result.size() == 1 && ((Map)result.get(0)).get("version").toString().startsWith("PostgreSQL");
            }
            catch (Exception e) {
                return false;
            }
        }

        public String getCreateQueueTableSql(String queueTableName, int maxJsonLength) {
            return "Create Table If Not Exists " + queueTableName + "(" + "id Bigserial Primary Key, " + "item varchar(" + maxJsonLength + ") Not NULL, " + "started_at Timestamp NULL, " + "prio Integer)";
        }
    }

    public static class MySql
    extends RelationalDatabaseType {
        public boolean dataSourceBelongToType(JdbcTemplate jdbcTemplate) {
            try {
                return jdbcTemplate.queryForList("SHOW VARIABLES LIKE 'version_comment'").size() > 0;
            }
            catch (Exception e) {
                return false;
            }
        }

        public String getCreateQueueTableSql(String queueTableName, int maxJsonLength) {
            return "Create Table If Not Exists " + queueTableName + "(" + "id Bigint NOT NULL AUTO_INCREMENT, " + "item varchar(" + maxJsonLength + ") Not NULL, " + "started_at Timestamp NULL, " + "prio Integer, " + "PRIMARY KEY (id))";
        }

        public String getSqlSelectForUpdate(String queueTableName) {
            return "Select id From " + queueTableName + " " + "Where started_at is NULL " + "Order By id " + "Limit 1 " + "For Update";
        }
    }

    public static class H2
    extends HSql {
        public boolean dataSourceBelongToType(JdbcTemplate jdbcTemplate) {
            try {
                return jdbcTemplate.queryForList("Select * From INFORMATION_SCHEMA.SETTINGS Where name='MVCC'").size() > 0;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class Oracle
    extends H2 {
        public boolean dataSourceBelongToType(JdbcTemplate jdbcTemplate) {
            try {
                Map result = jdbcTemplate.queryForMap("SELECT * FROM v$version WHERE banner LIKE 'Oracle%'");
                return result != null && result.size() == 1 && result.containsKey("BANNER");
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class HSql
    extends RelationalDatabaseType {
        public boolean dataSourceBelongToType(JdbcTemplate jdbcTemplate) {
            try {
                Map result = jdbcTemplate.queryForMap("Select Top 1 * From INFORMATION_SCHEMA.SYSTEM_TABLES");
                return result != null && result.containsKey("HSQLDB_TYPE");
            }
            catch (Exception e) {
                return false;
            }
        }

        public String getCreateQueueTableSql(String queueTableName, int maxJsonLength) {
            return "Create Table If Not Exists " + queueTableName + "(" + "id Bigint Generated By Default As Identity, " + "item varchar(" + maxJsonLength + ") Not NULL, " + "started_at Timestamp, " + "prio Integer" + ")";
        }

        public String getSqlSelectForUpdate(String queueTableName) {
            return "Select id From " + queueTableName + " " + "Where started_at is NULL " + "Order By id " + "Fetch First 1 Rows Only " + "For Update";
        }
    }
}

