/*
 * Decompiled with CFR 0.152.
 */
package com.github.parze;

import com.github.parze.RelationalDatabaseType;
import com.github.parze.TdbqException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class RelationalDatabaseTypeFactory {
    private static List<RelationalDatabaseType> relationalDatabaseTypeList = new ArrayList<RelationalDatabaseType>();

    public static RelationalDatabaseType getDataBaseType(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        for (RelationalDatabaseType relationalDatabaseType : relationalDatabaseTypeList) {
            if (!relationalDatabaseType.dataSourceBelongToType(jdbcTemplate)) continue;
            return relationalDatabaseType;
        }
        throw new TdbqException("Failed to find database type for given data source.");
    }

    static {
        relationalDatabaseTypeList.add(new RelationalDatabaseType.HSql());
        relationalDatabaseTypeList.add(new RelationalDatabaseType.H2());
        relationalDatabaseTypeList.add(new RelationalDatabaseType.MySql());
        relationalDatabaseTypeList.add(new RelationalDatabaseType.PostgresSql());
        relationalDatabaseTypeList.add(new RelationalDatabaseType.Oracle());
    }
}

