/*
 * Decompiled with CFR 0.152.
 */
package com.github.parze;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Worker {
    private Logger logger = LoggerFactory.getLogger(Worker.class);
    private WorkerThread workerThread;
    private Object notifiesWhenWorkerHasNewWork = new Object();
    private Object notifiesWhenAllWorkIsDone = new Object();
    private boolean shouldBeActive;
    private boolean workIsPendingForProcessing = false;
    private boolean isWaiting = false;
    private Date workLastFinished = null;
    private String name;

    public Worker(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void startWorker() {
        this.workerThread = new WorkerThread();
        this.workerThread.setDaemon(true);
        this.shouldBeActive = true;
        this.workerThread.start();
        this.logger.info("Started Worker " + this.getName());
    }

    public void stopWorker() {
        this.shouldBeActive = false;
    }

    public Date getWorkLastFinished() {
        return this.workLastFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWorkerThatWorkIsReadyForProcessing() {
        Object object = this.notifiesWhenWorkerHasNewWork;
        synchronized (object) {
            this.workIsPendingForProcessing = true;
            this.notifiesWhenWorkerHasNewWork.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAllWorkIsDone() {
        if (!this.workIsPendingForProcessing && this.isWaiting) {
            return;
        }
        try {
            Object object = this.notifiesWhenAllWorkIsDone;
            synchronized (object) {
                this.notifiesWhenAllWorkIsDone.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public abstract void computeWork();

    public class WorkerThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (Worker.this.shouldBeActive) {
                Object object = Worker.this.notifiesWhenWorkerHasNewWork;
                synchronized (object) {
                    if (!Worker.this.workIsPendingForProcessing) {
                        Object object2 = Worker.this.notifiesWhenAllWorkIsDone;
                        synchronized (object2) {
                            Worker.this.notifiesWhenAllWorkIsDone.notifyAll();
                        }
                        try {
                            Worker.this.isWaiting = true;
                            Worker.this.notifiesWhenWorkerHasNewWork.wait();
                            Worker.this.isWaiting = false;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    Worker.this.workIsPendingForProcessing = false;
                }
                try {
                    Worker.this.computeWork();
                }
                catch (Throwable e) {
                    Worker.this.logger.error("Exception was thrown when worker " + this.getName() + " computing work.", e);
                }
                Worker.this.workLastFinished = new Date();
            }
        }
    }
}

