/*
 * Decompiled with CFR 0.152.
 */
package com.github.parze;

import com.github.parze.Worker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workers<E extends Worker> {
    private List<E> workers = new ArrayList();

    public List<E> getWorkers() {
        return this.workers;
    }

    public void addWorker(E worker) {
        this.workers.add(worker);
    }

    public void startWorkers() {
        for (Worker worker : this.workers) {
            worker.startWorker();
        }
    }

    public Date getWorkLastFinished() {
        Date workLastFinished = new Date(0L);
        for (Worker worker : this.workers) {
            if (!worker.getWorkLastFinished().after(workLastFinished)) continue;
            workLastFinished = worker.getWorkLastFinished();
        }
        return workLastFinished;
    }

    public void waitUntilAllWorkersAreDone() {
        for (Worker worker : this.workers) {
            worker.waitUntilAllWorkIsDone();
        }
    }

    public void notifyWorkersThatWorkIsReadyForProcessing() {
        for (Worker worker : this.workers) {
            worker.notifyWorkerThatWorkIsReadyForProcessing();
        }
    }
}

