/*
 * Decompiled with CFR 0.152.
 */
package com.pytsoft.cachelock.connector;

import com.pytsoft.cachelock.connector.CacheClient;
import net.spy.memcached.internal.OperationFuture;

public class MemcachedClient
implements CacheClient {
    protected net.spy.memcached.MemcachedClient client;

    public MemcachedClient(net.spy.memcached.MemcachedClient client) {
        this.client = client;
    }

    @Override
    public boolean setnx(String key, String value, int expSeconds) {
        OperationFuture result = this.client.add(key, expSeconds, (Object)value);
        try {
            return (Boolean)result.get();
        }
        catch (Exception e) {
            LOG.error("Error occurs while performing setnx for key[%s] and value[%s], reason:[%s]", new Object[]{key, value, e.getMessage()});
            return false;
        }
    }

    @Override
    public boolean hsetnx(String key, String field, String value, int expSeconds) {
        return this.setnx(this.genHashKey(key, field), value, expSeconds);
    }

    @Override
    public String get(String key) {
        return this.client.get(key).toString();
    }

    @Override
    public String hget(String key, String field) {
        return this.get(this.genHashKey(key, field)).toString();
    }

    @Override
    public void del(String key) {
        this.client.delete(key);
    }

    @Override
    public void hdel(String key, String field) {
        this.del(this.genHashKey(key, field));
    }

    private String genHashKey(String key, String field) {
        return key + "___" + field;
    }
}

