/*
 * Decompiled with CFR 0.152.
 */
package com.pytsoft.cachelock.core;

import com.pytsoft.cachelock.config.Configuration;
import com.pytsoft.cachelock.connector.CacheClient;
import com.pytsoft.cachelock.util.KeyUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheLock
implements Lock {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected String key;
    protected String field;
    protected Configuration config;
    protected boolean hashLock = false;
    protected boolean locked = false;
    protected CacheClient client;

    public CacheLock(String key, CacheClient client) {
        this.key = "booking:locker::" + key;
        this.client = client;
    }

    public CacheLock(String key, CacheClient client, Configuration config) {
        this(key, client);
        this.config = config;
    }

    public CacheLock(String key, String field, CacheClient client) {
        this(key, client);
        this.field = "booking:locker::" + field;
        this.hashLock = true;
    }

    public CacheLock(String key, String field, CacheClient client, Configuration config) {
        this(key, field, client);
        this.config = config;
    }

    public String getKey() {
        return this.key;
    }

    public String getField() {
        return this.field;
    }

    public boolean isHashLock() {
        return this.hashLock;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public CacheClient getClient() {
        return this.client;
    }

    @Override
    public void lock() {
        try {
            this.tryLock(10L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            this.LOG.error(String.format("Unexpected interrupted exception!", e));
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.tryLock(10L, TimeUnit.DAYS);
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.LOG.error(String.format("Unexpected interrupted exception!", e));
            return false;
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        long lockExpire = this.config.getLockExpiration();
        int expSeconds = (int)(lockExpire / 1000L);
        String lockValue = KeyUtils.genLockValue(lockExpire);
        long nextInterval = this.config.getInitInterval();
        float priorityRatio = this.config.getPriorityRatio();
        long acquireTimeout = TimeUnit.MILLISECONDS.convert(time, unit);
        long begin = System.currentTimeMillis();
        while (true) {
            long current;
            if ((current = System.currentTimeMillis()) - begin > acquireTimeout) {
                this.LOG.error(String.format("Time out! Acquire key for target [%s, %s] failed.", this.key, this.field));
                return false;
            }
            boolean set = !this.hashLock ? this.client.setnx(this.key, lockValue, expSeconds) : this.client.hsetnx(this.key, this.field, lockValue, expSeconds);
            if (set) {
                this.locked = true;
                return true;
            }
            String prevLockValue = !this.hashLock ? this.client.get(this.key) : this.client.hget(this.key, this.field);
            if (StringUtils.equals((CharSequence)prevLockValue, (CharSequence)lockValue)) {
                this.locked = true;
                return true;
            }
            try {
                Thread.sleep(nextInterval);
                nextInterval = (long)((float)nextInterval * priorityRatio);
            }
            catch (InterruptedException e) {
                this.LOG.error(String.format("Lock acquiring process for target [%s, %s] interrupted unexpectedly! Failed!", this.key, this.field));
                return false;
            }
        }
    }

    @Override
    public void unlock() {
        if (this.locked) {
            if (!this.hashLock) {
                this.client.del(this.key);
            } else {
                this.client.hdel(this.key, this.field);
            }
            this.locked = false;
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "CacheLock{key='" + this.key + '\'' + ", field='" + this.field + '\'' + ", config=" + this.config + '}';
    }
}

