/*
 * Decompiled with CFR 0.152.
 */
package com.pytsoft.cachelock.util;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUtils {
    protected static Logger LOG = LoggerFactory.getLogger(KeyUtils.class);

    public static String genLockValue(long lockExpire) {
        long expireTime = System.currentTimeMillis() + lockExpire + 1L;
        return UUID.randomUUID().toString() + "::" + expireTime;
    }

    public static long parseTime(String lockValue) {
        if (lockValue != null) {
            try {
                String timeStr = StringUtils.split((String)lockValue, (String)"::")[1];
                return Long.parseLong(timeStr);
            }
            catch (Exception e) {
                LOG.warn(String.format("Input lock value[%s] parsed failed, reason:[%s], will return 0.", lockValue, e.getMessage()));
                return 0L;
            }
        }
        return 0L;
    }
}

