/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.apis.facebook.FacebookAccessTokenJsonExtractor;
import com.github.scribejava.apis.service.FacebookService;
import com.github.scribejava.core.builder.api.ClientAuthenticationType;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Verb;
import java.io.OutputStream;

public class FacebookApi
extends DefaultApi20 {
    private final String version;

    protected FacebookApi() {
        this("2.11");
    }

    protected FacebookApi(String version) {
        this.version = version;
    }

    public static FacebookApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static FacebookApi customVersion(String version) {
        return new FacebookApi(version);
    }

    public Verb getAccessTokenVerb() {
        return Verb.GET;
    }

    public String getAccessTokenEndpoint() {
        return "https://graph.facebook.com/v" + this.version + "/oauth/access_token";
    }

    public String getRefreshTokenEndpoint() {
        throw new UnsupportedOperationException("Facebook doesn't support refreshing tokens");
    }

    protected String getAuthorizationBaseUrl() {
        return "https://www.facebook.com/v" + this.version + "/dialog/oauth";
    }

    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return FacebookAccessTokenJsonExtractor.instance();
    }

    public ClientAuthenticationType getClientAuthenticationType() {
        return ClientAuthenticationType.REQUEST_BODY;
    }

    public FacebookService createService(String apiKey, String apiSecret, String callback, String scope, OutputStream debugStream, String state, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        return new FacebookService(this, apiKey, apiSecret, callback, scope, state, responseType, userAgent, httpClientConfig, httpClient);
    }

    private static class InstanceHolder {
        private static final FacebookApi INSTANCE = new FacebookApi();

        private InstanceHolder() {
        }
    }
}

