/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.apis.imgur.ImgurOAuthService;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.ParameterList;
import java.io.OutputStream;
import java.util.Map;

public class ImgurApi
extends DefaultApi20 {
    protected ImgurApi() {
    }

    public static ImgurApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getAccessTokenEndpoint() {
        return "https://api.imgur.com/oauth2/token";
    }

    public String getAuthorizationUrl(String responseType, String apiKey, String callback, String scope, String state, Map<String, String> additionalParams) {
        ParameterList parameters = new ParameterList(additionalParams);
        parameters.add("response_type", ImgurApi.isOob(callback) ? "pin" : "code");
        parameters.add("client_id", apiKey);
        if (callback != null) {
            parameters.add("redirect_uri", callback);
        }
        if (scope != null) {
            parameters.add("scope", scope);
        }
        if (state != null) {
            parameters.add("state", state);
        }
        return parameters.appendTo("https://api.imgur.com/oauth2/authorize");
    }

    protected String getAuthorizationBaseUrl() {
        throw new UnsupportedOperationException("use getAuthorizationUrl instead");
    }

    @Deprecated
    public ImgurOAuthService createService(String apiKey, String apiSecret, String callback, String scope, OutputStream debugStream, String state, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        return new ImgurOAuthService(this, apiKey, apiSecret, callback, scope, state, responseType, userAgent, httpClientConfig, httpClient);
    }

    public ImgurOAuthService createService(String apiKey, String apiSecret, String callback, String scope, OutputStream debugStream, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        return this.createService(apiKey, apiSecret, callback, scope, debugStream, null, responseType, userAgent, httpClientConfig, httpClient);
    }

    public static boolean isOob(String callback) {
        return "oob".equals(callback);
    }

    private static class InstanceHolder {
        private static final ImgurApi INSTANCE = new ImgurApi();

        private InstanceHolder() {
        }
    }
}

