/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.instagram;

import com.github.scribejava.apis.InstagramApi;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class InstagramService
extends OAuth20Service {
    public InstagramService(InstagramApi api, String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super((DefaultApi20)api, apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
    }

    protected OAuthRequest createRefreshTokenRequest(String accessToken, String scope) {
        if (accessToken == null || accessToken.isEmpty()) {
            throw new IllegalArgumentException("The accessToken cannot be null or empty");
        }
        OAuthRequest request = new OAuthRequest(Verb.GET, this.getApi().getRefreshTokenEndpoint());
        request.addParameter("grant_type", "ig_refresh_token");
        request.addParameter("access_token", accessToken);
        this.logRequestWithParams("refresh token", request);
        return request;
    }

    public Future<OAuth2AccessToken> getLongLivedAccessTokenAsync(OAuth2AccessToken accessToken) {
        return this.getLongLivedAccessToken(accessToken.getAccessToken(), null);
    }

    public Future<OAuth2AccessToken> getLongLivedAccessTokenAsync(String shortLivedAccessToken) {
        return this.getLongLivedAccessToken(shortLivedAccessToken, null);
    }

    public Future<OAuth2AccessToken> getLongLivedAccessToken(String shortLivedAccessToken, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        return this.sendAccessTokenRequestAsync(this.createLongLivedAccessTokenRequest(shortLivedAccessToken), callback);
    }

    public Future<OAuth2AccessToken> getLongLivedAccessToken(OAuth2AccessToken accessToken, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        return this.getLongLivedAccessToken(accessToken.getAccessToken(), callback);
    }

    public OAuth2AccessToken getLongLivedAccessToken(OAuth2AccessToken accessToken) throws InterruptedException, ExecutionException, IOException {
        return this.getLongLivedAccessToken(accessToken.getAccessToken());
    }

    public OAuth2AccessToken getLongLivedAccessToken(String shortLivedAccessToken) throws InterruptedException, ExecutionException, IOException {
        OAuthRequest request = this.createLongLivedAccessTokenRequest(shortLivedAccessToken);
        return this.sendAccessTokenRequestSync(request);
    }

    private OAuthRequest createLongLivedAccessTokenRequest(String shortLivedAccessToken) {
        OAuthRequest request = new OAuthRequest(Verb.GET, "https://graph.instagram.com/access_token");
        this.getApi().getClientAuthentication().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        request.addParameter("grant_type", "ig_exchange_token");
        request.addParameter("access_token", shortLivedAccessToken);
        if (this.isDebug()) {
            this.log("created long-lived access token request with body params [%s], query string params [%s]", new Object[]{request.getBodyParams().asFormUrlEncodedString(), request.getQueryStringParams().asFormUrlEncodedString()});
        }
        return request;
    }
}

