/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verifier;
import com.github.scribejava.core.oauth.OAuthService;
import com.ning.http.client.ProxyServer;
import java.io.IOException;
import java.util.concurrent.Future;

public class OAuth20ServiceImpl
extends OAuthService {
    private static final String VERSION = "2.0";
    private final DefaultApi20 api;

    public OAuth20ServiceImpl(DefaultApi20 api, OAuthConfig config) {
        super(config);
        this.api = api;
    }

    @Override
    public Token getAccessToken(Token requestToken, Verifier verifier) {
        Response response = this.createAccessTokenRequest(verifier, new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this)).send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    @Override
    public Future<Token> getAccessTokenAsync(Token requestToken, Verifier verifier, OAuthAsyncRequestCallback<Token> callback) {
        return this.getAccessTokenAsync(requestToken, verifier, callback, null);
    }

    @Override
    public Future<Token> getAccessTokenAsync(Token requestToken, Verifier verifier, OAuthAsyncRequestCallback<Token> callback, ProxyServer proxyServer) {
        OAuthRequestAsync request = this.createAccessTokenRequest(verifier, new OAuthRequestAsync(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this));
        return request.sendAsync(callback, new OAuthRequestAsync.ResponseConverter<Token>(){

            @Override
            public Token convert(com.ning.http.client.Response response) throws IOException {
                return OAuth20ServiceImpl.this.getApi().getAccessTokenExtractor().extract(OAuthRequestAsync.RESPONSE_CONVERTER.convert(response).getBody());
            }
        }, proxyServer);
    }

    protected <T extends AbstractRequest> T createAccessTokenRequest(Verifier verifier, T request) {
        OAuthConfig config = this.getConfig();
        request.addParameter("client_id", config.getApiKey());
        request.addParameter("client_secret", config.getApiSecret());
        request.addParameter("code", verifier.getValue());
        request.addParameter("redirect_uri", config.getCallback());
        if (config.hasScope()) {
            request.addParameter("scope", config.getScope());
        }
        if (config.hasGrantType()) {
            request.addParameter("grant_type", config.getGrantType());
        }
        return request;
    }

    @Override
    public Token getRequestToken() {
        throw new UnsupportedOperationException("Unsupported operation, please use 'getAuthorizationUrl' and redirect your users there");
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void signRequest(Token accessToken, AbstractRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getToken());
    }

    @Override
    public String getAuthorizationUrl(Token requestToken) {
        return this.api.getAuthorizationUrl(this.getConfig());
    }

    public DefaultApi20 getApi() {
        return this.api;
    }
}

