/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.exceptions.OAuthConnectionException;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.ForceTypeOfHttpRequest;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.ScribeJavaConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuthService;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class OAuthRequest
extends AbstractRequest {
    private HttpURLConnection connection;

    public OAuthRequest(Verb verb, String url, OAuthService service) {
        super(verb, url, service);
    }

    public Response send() {
        ForceTypeOfHttpRequest forceTypeOfHttpRequest = ScribeJavaConfig.getForceTypeOfHttpRequests();
        if (ForceTypeOfHttpRequest.FORCE_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
            throw new OAuthException("Cannot use sync operations, only async");
        }
        if (ForceTypeOfHttpRequest.PREFER_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
            this.getService().getConfig().log("Cannot use sync operations, only async");
        }
        try {
            this.createConnection();
            return this.doSend();
        }
        catch (IOException | RuntimeException e) {
            throw new OAuthConnectionException(this.getCompleteUrl(), e);
        }
    }

    Response doSend() throws IOException {
        Verb verb = this.getVerb();
        this.connection.setRequestMethod(verb.name());
        OAuthConfig config = this.getService().getConfig();
        if (config.getConnectTimeout() != null) {
            this.connection.setConnectTimeout(config.getConnectTimeout());
        }
        if (config.getReadTimeout() != null) {
            this.connection.setReadTimeout(config.getReadTimeout());
        }
        this.addHeaders();
        if (this.hasBodyContent()) {
            this.addBody(this.getByteBodyContents());
        }
        return new Response(this.connection);
    }

    private void createConnection() throws IOException {
        String completeUrl = this.getCompleteUrl();
        if (this.connection == null) {
            System.setProperty("http.keepAlive", this.isConnectionKeepAlive() ? "true" : "false");
            this.connection = (HttpURLConnection)new URL(completeUrl).openConnection();
            this.connection.setInstanceFollowRedirects(this.isFollowRedirects());
        }
    }

    void addHeaders() {
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            this.connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        String userAgent = this.getService().getConfig().getUserAgent();
        if (userAgent != null) {
            this.connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    void addBody(byte[] content) throws IOException {
        this.connection.setRequestProperty("Content-Length", String.valueOf(content.length));
        if (this.connection.getRequestProperty("Content-Type") == null) {
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        this.connection.setDoOutput(true);
        this.connection.getOutputStream().write(content);
    }

    void setConnection(HttpURLConnection connection) {
        this.connection = connection;
    }
}

