/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth1Token;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractOAuth1TokenExtractor<T extends OAuth1Token>
implements TokenExtractor<T> {
    private static final String OAUTH_TOKEN_REGEXP = "oauth_token=([^&]+)";
    private static final String OAUTH_TOKEN_SECRET_REGEXP = "oauth_token_secret=([^&]*)";

    @Override
    public T extract(String response) {
        Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
        String token = this.extract(response, Pattern.compile(OAUTH_TOKEN_REGEXP));
        String secret = this.extract(response, Pattern.compile(OAUTH_TOKEN_SECRET_REGEXP));
        return this.createToken(token, secret, response);
    }

    private String extract(String response, Pattern p) {
        Matcher matcher = p.matcher(response);
        if (matcher.find() && matcher.groupCount() >= 1) {
            return OAuthEncoder.decode(matcher.group(1));
        }
        throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: '" + response + "'", null);
    }

    protected abstract T createToken(String var1, String var2, String var3);
}

