/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.OAuth2AccessTokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Response;
import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OAuth2AccessTokenExtractorTest {
    private OAuth2AccessTokenExtractor extractor;

    @Before
    public void setUp() {
        this.extractor = OAuth2AccessTokenExtractor.instance();
    }

    @Test
    public void shouldExtractTokenFromOAuthStandardResponse() throws IOException {
        OAuth2AccessToken extracted;
        String responseBody = "access_token=166942940015970|2.2ltzWXYNDjCtg5ZDVVJJeg__.3600.1295816400-548517159|RsXNdKrpxg8L6QNLWcs2TVTmcaE";
        try (Response response = OAuth2AccessTokenExtractorTest.ok("access_token=166942940015970|2.2ltzWXYNDjCtg5ZDVVJJeg__.3600.1295816400-548517159|RsXNdKrpxg8L6QNLWcs2TVTmcaE");){
            extracted = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"166942940015970|2.2ltzWXYNDjCtg5ZDVVJJeg__.3600.1295816400-548517159|RsXNdKrpxg8L6QNLWcs2TVTmcaE", (Object)extracted.getAccessToken());
    }

    @Test
    public void shouldExtractTokenFromResponseWithExpiresParam() throws IOException {
        OAuth2AccessToken extracted;
        String responseBody = "access_token=166942940015970|2.2ltzWXYNDjCtg5ZDVVJJeg__.3600.1295816400-548517159|RsXNdKrpxg8L6QNLWcs2TVTmcaE&expires_in=5108";
        try (Response response = OAuth2AccessTokenExtractorTest.ok("access_token=166942940015970|2.2ltzWXYNDjCtg5ZDVVJJeg__.3600.1295816400-548517159|RsXNdKrpxg8L6QNLWcs2TVTmcaE&expires_in=5108");){
            extracted = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"166942940015970|2.2ltzWXYNDjCtg5ZDVVJJeg__.3600.1295816400-548517159|RsXNdKrpxg8L6QNLWcs2TVTmcaE", (Object)extracted.getAccessToken());
        Assert.assertEquals((Object)5108, (Object)extracted.getExpiresIn());
    }

    @Test
    public void shouldExtractTokenFromResponseWithExpiresAndRefreshParam() throws IOException {
        OAuth2AccessToken extracted;
        String responseBody = "access_token=166942940015970|2.2ltzWXYNDjCtg5ZDVVJJeg__.3600.1295816400-548517159|RsXNdKrpxg8L6QNLWcs2TVTmcaE&expires_in=5108&token_type=bearer&refresh_token=166942940015970";
        try (Response response = OAuth2AccessTokenExtractorTest.ok("access_token=166942940015970|2.2ltzWXYNDjCtg5ZDVVJJeg__.3600.1295816400-548517159|RsXNdKrpxg8L6QNLWcs2TVTmcaE&expires_in=5108&token_type=bearer&refresh_token=166942940015970");){
            extracted = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"166942940015970|2.2ltzWXYNDjCtg5ZDVVJJeg__.3600.1295816400-548517159|RsXNdKrpxg8L6QNLWcs2TVTmcaE", (Object)extracted.getAccessToken());
        Assert.assertEquals((Object)5108, (Object)extracted.getExpiresIn());
        Assert.assertEquals((Object)"bearer", (Object)extracted.getTokenType());
        Assert.assertEquals((Object)"166942940015970", (Object)extracted.getRefreshToken());
    }

    @Test
    public void shouldExtractTokenFromResponseWithManyParameters() throws IOException {
        OAuth2AccessToken extracted;
        String responseBody = "access_token=foo1234&other_stuff=yeah_we_have_this_too&number=42";
        try (Response response = OAuth2AccessTokenExtractorTest.ok("access_token=foo1234&other_stuff=yeah_we_have_this_too&number=42");){
            extracted = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"foo1234", (Object)extracted.getAccessToken());
    }

    @Test(expected=OAuthException.class)
    public void shouldThrowExceptionIfErrorResponse() throws IOException {
        String responseBody = "";
        try (Response response = OAuth2AccessTokenExtractorTest.error("");){
            this.extractor.extract(response);
        }
    }

    @Test(expected=OAuthException.class)
    public void shouldThrowExceptionIfTokenIsAbsent() throws IOException {
        String responseBody = "&expires=5108";
        try (Response response = OAuth2AccessTokenExtractorTest.ok("&expires=5108");){
            this.extractor.extract(response);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfResponseIsNull() throws IOException {
        try (Response response = OAuth2AccessTokenExtractorTest.ok(null);){
            this.extractor.extract(response);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfResponseIsEmptyString() throws IOException {
        String responseBody = "";
        try (Response response = OAuth2AccessTokenExtractorTest.ok("");){
            this.extractor.extract(response);
        }
    }

    private static Response ok(String body) {
        return new Response(200, null, Collections.emptyMap(), body);
    }

    private static Response error(String body) {
        return new Response(400, null, Collections.emptyMap(), body);
    }
}

