package com.github.scribejava.core.model;

/**
 * represents Authorization Response http://tools.ietf.org/html/rfc6749#section-4.1.2
 *
 * If the resource owner grants the access request, the authorization server issues an authorization code and delivers
 * it to the client by adding the following parameters to the query component of the redirection URI using the
 * "application/x-www-form-urlencoded" format.
 *
 */
public class OAuth2Authorization {

    /**
     * REQUIRED. The authorization code generated by the authorization server. The authorization code MUST expire
     * shortly after it is issued to mitigate the risk of leaks. A maximum authorization code lifetime of 10 minutes is
     * RECOMMENDED. The client MUST NOT use the authorization code more than once. If an authorization code is used more
     * than once, the authorization server MUST deny the request and SHOULD revoke (when possible) all tokens previously
     * issued based on that authorization code. The authorization code is bound to the client identifier and redirection
     * URI.
     */
    private String code;
    /**
     * REQUIRED if the "state" parameter was present in the client authorization request. The exact value received from
     * the client.
     */
    private String state;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }
}
