/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.ObjectMother;
import com.github.scribejava.core.exceptions.OAuthParametersMissingException;
import com.github.scribejava.core.extractors.HeaderExtractorImpl;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class HeaderExtractorTest {
    private HeaderExtractorImpl extractor;
    private OAuthRequest request;

    @Before
    public void setUp() {
        this.request = ObjectMother.createSampleOAuthRequest();
        this.extractor = new HeaderExtractorImpl();
    }

    @Test
    public void shouldExtractStandardHeader() {
        String header = this.extractor.extract(this.request);
        String oauth = "OAuth ";
        String callback = "oauth_callback=\"http%3A%2F%2Fexample%2Fcallback\"";
        String signature = "oauth_signature=\"OAuth-Signature\"";
        String key = "oauth_consumer_key=\"AS%23%24%5E%2A%40%26\"";
        String timestamp = "oauth_timestamp=\"123456\"";
        Assert.assertTrue((boolean)header.startsWith("OAuth "));
        Assert.assertTrue((boolean)header.contains("oauth_callback=\"http%3A%2F%2Fexample%2Fcallback\""));
        Assert.assertTrue((boolean)header.contains("oauth_signature=\"OAuth-Signature\""));
        Assert.assertTrue((boolean)header.contains("oauth_consumer_key=\"AS%23%24%5E%2A%40%26\""));
        Assert.assertTrue((boolean)header.contains("oauth_timestamp=\"123456\""));
        Assert.assertEquals((Object)", , , ", (Object)header.replaceFirst("OAuth ", "").replaceFirst("oauth_callback=\"http%3A%2F%2Fexample%2Fcallback\"", "").replaceFirst("oauth_signature=\"OAuth-Signature\"", "").replaceFirst("oauth_consumer_key=\"AS%23%24%5E%2A%40%26\"", "").replaceFirst("oauth_timestamp=\"123456\"", ""));
    }

    public void shouldExceptionIfRequestIsNull() {
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                HeaderExtractorTest.this.extractor.extract(null);
            }
        });
    }

    public void shouldExceptionIfRequestHasNoOAuthParams() {
        final OAuthRequest emptyRequest = new OAuthRequest(Verb.GET, "http://example.com");
        Assert.assertThrows(OAuthParametersMissingException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                HeaderExtractorTest.this.extractor.extract(emptyRequest);
            }
        });
    }
}

