/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.model;

public class BaseResponse {
    private int status;
    private String cause;
    private Exception exception;

    protected BaseResponse(BaseResponseBuilder<?, ?> b) {
        this.status = b.status;
        this.cause = b.cause;
        this.exception = b.exception;
    }

    public static BaseResponseBuilder<?, ?> builder() {
        return new BaseResponseBuilderImpl();
    }

    public int getStatus() {
        return this.status;
    }

    public String getCause() {
        return this.cause;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public static abstract class BaseResponseBuilder<C extends BaseResponse, B extends BaseResponseBuilder<C, B>> {
        private int status;
        private String cause;
        private Exception exception;

        protected abstract B self();

        public abstract C build();

        public B status(int status) {
            this.status = status;
            return this.self();
        }

        public B cause(String cause) {
            this.cause = cause;
            return this.self();
        }

        public B exception(Exception exception) {
            this.exception = exception;
            return this.self();
        }

        public String toString() {
            return "BaseResponse.BaseResponseBuilder(status=" + this.status + ", cause=" + this.cause + ", exception=" + this.exception + ")";
        }
    }

    private static final class BaseResponseBuilderImpl
    extends BaseResponseBuilder<BaseResponse, BaseResponseBuilderImpl> {
        private BaseResponseBuilderImpl() {
        }

        @Override
        protected BaseResponseBuilderImpl self() {
            return this;
        }

        @Override
        public BaseResponse build() {
            return new BaseResponse(this);
        }
    }
}

