/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.sonus21.rqueue.utils.SerializationUtils;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;

public class GenericMessageConverter
implements SmartMessageConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericMessageConverter.class);
    private final SmartMessageSerDes smartMessageSerDes;

    public GenericMessageConverter() {
        ObjectMapper mapper = SerializationUtils.createObjectMapper();
        this.smartMessageSerDes = new SmartMessageSerDes(mapper);
    }

    public GenericMessageConverter(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
        this.smartMessageSerDes = new SmartMessageSerDes(objectMapper);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        log.debug("Payload: {} headers: {}", payload, (Object)headers);
        String message = this.smartMessageSerDes.serialize(payload);
        if (message == null) {
            return null;
        }
        return new GenericMessage((Object)message);
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass, Object conversionHint) {
        log.debug("Message: {} class: {} hint: {}", new Object[]{message, targetClass, conversionHint});
        return this.fromMessage(message, targetClass);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers, Object conversionHint) {
        log.debug("Payload: {} headers: {} hint: {}", new Object[]{payload, headers, conversionHint});
        return this.toMessage(payload, headers);
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        String payload;
        log.debug("Message: {} class: {}", message, targetClass);
        try {
            payload = (String)message.getPayload();
        }
        catch (ClassCastException e) {
            return null;
        }
        return this.smartMessageSerDes.deserialize(payload);
    }

    public static class SmartMessageSerDes {
        private final ObjectMapper objectMapper;

        public SmartMessageSerDes(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        private String[] splitClassNames(String name) {
            return name.split("#");
        }

        private String getClassNameForCollection(String name, Collection<?> payload) {
            if (payload instanceof List) {
                if (payload.isEmpty()) {
                    return null;
                }
                String itemClassName = this.getClassName(((List)payload).get(0));
                if (itemClassName == null) {
                    return null;
                }
                return name + '#' + itemClassName;
            }
            return null;
        }

        private String getGenericFieldBasedClassName(Class<?> clazz) {
            TypeVariable<Class<?>>[] typeVariables = clazz.getTypeParameters();
            if (typeVariables.length == 0) {
                return clazz.getName();
            }
            return null;
        }

        private String getClassName(Object payload) {
            Class<?> payloadClass = payload.getClass();
            String name = payloadClass.getName();
            if (payload instanceof Collection) {
                return this.getClassNameForCollection(name, (Collection)payload);
            }
            return this.getGenericFieldBasedClassName(payloadClass);
        }

        private JavaType getTargetType(Msg msg) throws ClassNotFoundException {
            String[] classNames = this.splitClassNames(msg.getName());
            if (classNames.length == 1) {
                Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(msg.getName());
                return this.objectMapper.getTypeFactory().constructType(c);
            }
            Class<?> envelopeClass = Thread.currentThread().getContextClassLoader().loadClass(classNames[0]);
            Class[] classes = new Class[classNames.length - 1];
            for (int i = 1; i < classNames.length; ++i) {
                classes[i - 1] = Thread.currentThread().getContextClassLoader().loadClass(classNames[i]);
            }
            return this.objectMapper.getTypeFactory().constructParametricType(envelopeClass, classes);
        }

        public Object deserialize(String payload) {
            try {
                if (SerializationUtils.isJson(payload)) {
                    Msg msg = (Msg)this.objectMapper.readValue(payload, Msg.class);
                    JavaType type = this.getTargetType(msg);
                    return this.objectMapper.readValue(msg.msg, type);
                }
            }
            catch (Exception e) {
                log.warn("Deserialization of message {} failed", (Object)payload, (Object)e);
            }
            return null;
        }

        public <T> T deserialize(byte[] payload, Class<T> clazz) {
            if (SerializationUtils.isEmpty(payload)) {
                return null;
            }
            try {
                return (T)this.objectMapper.readValue(payload, clazz);
            }
            catch (Exception e) {
                log.warn("Deserialization of message {} failed", (Object)new String(payload), (Object)e);
                return null;
            }
        }

        public String serialize(Object payload) {
            String name = this.getClassName(payload);
            if (name == null) {
                return null;
            }
            try {
                String msg = this.objectMapper.writeValueAsString(payload);
                Msg message = new Msg(msg, name);
                return this.objectMapper.writeValueAsString((Object)message);
            }
            catch (JsonProcessingException e) {
                log.warn("Serialisation failed", (Throwable)e);
                return null;
            }
        }
    }

    private static class Msg {
        private String msg;
        private String name;

        @Generated
        public String getMsg() {
            return this.msg;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public Msg() {
        }

        @Generated
        public Msg(String msg, String name) {
            this.msg = msg;
            this.name = name;
        }
    }
}

