/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

class ScheduledTaskDetail {
    private final Future<?> future;
    private final long startTime;
    private final String id;

    ScheduledTaskDetail(long startTime, Future<?> future) {
        this.startTime = startTime;
        this.future = future;
        this.id = UUID.randomUUID().toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.future instanceof ScheduledFuture) {
            sb.append("ScheduledFuture(delay=");
            sb.append(((ScheduledFuture)this.future).getDelay(TimeUnit.MILLISECONDS));
            sb.append("Ms, ");
        } else {
            sb.append("Future(");
        }
        sb.append("id=");
        sb.append(this.id);
        sb.append(", startTime=");
        sb.append(this.startTime);
        sb.append(", currentTime=");
        sb.append(System.currentTimeMillis());
        sb.append(")");
        return sb.toString();
    }

    @Generated
    public Future<?> getFuture() {
        return this.future;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public String getId() {
        return this.id;
    }
}

