/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.RqueueBeanProvider;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.middleware.Middleware;
import com.github.sonus21.rqueue.core.support.MessageProcessor;
import com.github.sonus21.rqueue.listener.DefaultRqueuePoller;
import com.github.sonus21.rqueue.listener.MappingInformation;
import com.github.sonus21.rqueue.listener.MessageProcessorHandler;
import com.github.sonus21.rqueue.listener.PostProcessingHandler;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageHandler;
import com.github.sonus21.rqueue.listener.StrictPriorityPoller;
import com.github.sonus21.rqueue.listener.WeightedPriorityPoller;
import com.github.sonus21.rqueue.models.Concurrency;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.models.enums.PriorityMode;
import com.github.sonus21.rqueue.models.event.RqueueBootstrapEvent;
import com.github.sonus21.rqueue.models.event.RqueueQueuePauseEvent;
import com.github.sonus21.rqueue.utils.QueueThreadPool;
import com.github.sonus21.rqueue.utils.StringUtils;
import com.github.sonus21.rqueue.utils.ThreadUtils;
import com.github.sonus21.rqueue.utils.backoff.FixedTaskExecutionBackOff;
import com.github.sonus21.rqueue.utils.backoff.TaskExecutionBackOff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RqueueMessageListenerContainer
implements InitializingBean,
DisposableBean,
SmartLifecycle,
BeanNameAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageListenerContainer.class);
    public static final String EVENT_SOURCE = "RqueueMessageListenerContainer";
    private static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(RqueueMessageListenerContainer.class);
    private final Object lifecycleMgr = new Object();
    private final RqueueMessageTemplate rqueueMessageTemplate;
    private final RqueueMessageHandler rqueueMessageHandler;
    private MessageProcessor discardMessageProcessor;
    private MessageProcessor deadLetterQueueMessageProcessor;
    private MessageProcessor manualDeletionMessageProcessor;
    private MessageProcessor postExecutionMessageProcessor;
    private MessageProcessor preExecutionMessageProcessor;
    private TaskExecutionBackOff taskExecutionBackOff = new FixedTaskExecutionBackOff();
    private PostProcessingHandler postProcessingHandler;
    final QueueStateMgr queueStateMgr = new QueueStateMgr();
    private final Map<String, Boolean> queueRunningState = new ConcurrentHashMap<String, Boolean>();
    private final ConcurrentHashMap<String, Future<?>> scheduledFutureByQueue = new ConcurrentHashMap();
    private final Map<String, QueueThreadPool> queueThreadMap = new ConcurrentHashMap<String, QueueThreadPool>();
    private AsyncTaskExecutor taskExecutor;
    @Autowired
    protected RqueueBeanProvider rqueueBeanProvider;
    private Integer maxNumWorkers;
    private String beanName;
    private boolean defaultTaskExecutor = false;
    private boolean autoStartup = true;
    private boolean running = false;
    private long backOffTime = 5000L;
    private long maxWorkerWaitTime = 20000L;
    private long pollingInterval = 200L;
    private int phase = Integer.MAX_VALUE;
    private PriorityMode priorityMode;
    List<Middleware> middlewares;

    public RqueueMessageListenerContainer(RqueueMessageHandler rqueueMessageHandler, RqueueMessageTemplate rqueueMessageTemplate) {
        Assert.notNull((Object)((Object)rqueueMessageHandler), (String)"rqueueMessageHandler cannot be null");
        Assert.notNull((Object)rqueueMessageTemplate, (String)"rqueueMessageTemplate cannot be null");
        this.rqueueMessageHandler = rqueueMessageHandler;
        this.rqueueMessageTemplate = rqueueMessageTemplate;
        this.deadLetterQueueMessageProcessor = this.discardMessageProcessor = new MessageProcessor(){};
        this.manualDeletionMessageProcessor = this.discardMessageProcessor;
        this.postExecutionMessageProcessor = this.discardMessageProcessor;
        this.preExecutionMessageProcessor = this.discardMessageProcessor;
    }

    public RqueueMessageTemplate getRqueueMessageTemplate() {
        return this.rqueueMessageTemplate;
    }

    public long getMaxWorkerWaitTime() {
        return this.maxWorkerWaitTime;
    }

    public void setMaxWorkerWaitTime(long stopTime) {
        this.maxWorkerWaitTime = stopTime;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public RqueueMessageHandler getRqueueMessageHandler() {
        return this.rqueueMessageHandler;
    }

    public Integer getMaxNumWorkers() {
        return this.maxNumWorkers;
    }

    public void setMaxNumWorkers(int maxNumWorkers) {
        if (maxNumWorkers < 1) {
            throw new IllegalArgumentException("maxNumWorkers must be greater than zero");
        }
        this.maxNumWorkers = maxNumWorkers;
    }

    public long getBackOffTime() {
        return this.backOffTime;
    }

    public void setBackOffTime(long backOffTime) {
        this.backOffTime = backOffTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Object object = this.lifecycleMgr;
        synchronized (object) {
            this.stop();
            this.doDestroy();
        }
    }

    protected void doDestroy() {
        ThreadPoolTaskExecutor executor;
        HashSet<String> destroyedExecutors = new HashSet<String>();
        for (Map.Entry<String, QueueThreadPool> entry : this.queueThreadMap.entrySet()) {
            QueueThreadPool queueThreadPool = entry.getValue();
            String name = queueThreadPool.destroy();
            if (StringUtils.isEmpty(name)) continue;
            destroyedExecutors.add(name);
        }
        if (this.defaultTaskExecutor && this.taskExecutor != null && !destroyedExecutors.contains((executor = (ThreadPoolTaskExecutor)this.taskExecutor).getThreadNamePrefix())) {
            executor.destroy();
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifecycleMgr;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    private void initializeQueueRegistry() {
        log.info("Initializing queue registry");
        EndpointRegistry.delete();
        for (MappingInformation mappingInformation : this.rqueueMessageHandler.getHandlerMethodMap().keySet()) {
            for (String queue : mappingInformation.getQueueNames()) {
                for (QueueDetail queueDetail : this.getQueueDetail(queue, mappingInformation)) {
                    EndpointRegistry.register(queueDetail);
                }
            }
        }
    }

    private void initializeQueue() {
        List<QueueDetail> queueDetails = EndpointRegistry.getActiveQueueDetails();
        if (queueDetails.isEmpty()) {
            return;
        }
        if (this.taskExecutor == null) {
            this.defaultTaskExecutor = true;
            this.taskExecutor = this.createDefaultTaskExecutor(queueDetails);
        } else {
            this.initializeThreadMap(queueDetails, this.taskExecutor, false, queueDetails.size());
        }
        this.initializeRunningQueueState();
    }

    private void initialize() {
        this.initializeQueue();
        this.postProcessingHandler = new PostProcessingHandler(this.rqueueBeanProvider.getRqueueWebConfig(), this.rqueueBeanProvider.getApplicationEventPublisher(), this.rqueueMessageTemplate, this.taskExecutionBackOff, new MessageProcessorHandler(this.manualDeletionMessageProcessor, this.deadLetterQueueMessageProcessor, this.discardMessageProcessor, this.postExecutionMessageProcessor), this.rqueueBeanProvider.getRqueueSystemConfigDao());
        this.rqueueBeanProvider.setPreExecutionMessageProcessor(this.preExecutionMessageProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Object object = this.lifecycleMgr;
        synchronized (object) {
            RqueueConfig rqueueConfig = this.rqueueBeanProvider.getRqueueConfig();
            this.initializeQueueRegistry();
            if (rqueueConfig.isProducer()) {
                log.info("Producer mode nothing to do...");
            } else {
                this.initialize();
            }
            this.lifecycleMgr.notifyAll();
        }
    }

    private void initializeThreadMap(List<QueueDetail> queueDetails, AsyncTaskExecutor taskExecutor, boolean defaultExecutor, int workersCount) {
        for (QueueDetail queueDetail : queueDetails) {
            this.queueThreadMap.put(queueDetail.getName(), new QueueThreadPool(taskExecutor, defaultExecutor, workersCount));
        }
    }

    private void initializeRunningQueueState() {
        for (String queue : EndpointRegistry.getActiveQueues()) {
            this.queueRunningState.put(queue, false);
        }
    }

    private int getWorkersCount(int queueCount) {
        return this.maxNumWorkers == null ? queueCount * 2 : this.maxNumWorkers;
    }

    private AsyncTaskExecutor createTaskExecutor(int corePoolSize, int maxPoolSize, int queueCapacity) {
        String name = this.getBeanName();
        String prefix = name != null ? name + "-" : DEFAULT_THREAD_NAME_PREFIX;
        return ThreadUtils.createTaskExecutor(DEFAULT_THREAD_NAME_PREFIX, prefix, corePoolSize, maxPoolSize, queueCapacity);
    }

    private AsyncTaskExecutor createNonConcurrencyBasedExecutor(List<QueueDetail> queueDetails, int pollerCount) {
        int workersCount = this.getWorkersCount(queueDetails.size());
        int maxPoolSize = workersCount + pollerCount;
        int corePoolSize = queueDetails.size() + pollerCount;
        int queueCapacity = 0;
        AsyncTaskExecutor executor = this.createTaskExecutor(corePoolSize, maxPoolSize, queueCapacity);
        this.initializeThreadMap(queueDetails, executor, true, workersCount);
        return executor;
    }

    private void createExecutor(QueueDetail queueDetail) {
        Concurrency concurrency = queueDetail.getConcurrency();
        int queueCapacity = 0;
        int maxJobs = concurrency.getMax();
        int corePoolSize = concurrency.getMin();
        int maxPoolSize = concurrency.getMax();
        AsyncTaskExecutor executor = this.createTaskExecutor(queueDetail, corePoolSize, maxPoolSize, queueCapacity);
        QueueThreadPool threadPool = new QueueThreadPool(executor, true, maxJobs);
        this.queueThreadMap.put(queueDetail.getName(), threadPool);
    }

    public AsyncTaskExecutor createDefaultTaskExecutor(List<QueueDetail> registeredActiveQueueDetail) {
        List queueDetails = registeredActiveQueueDetail.stream().filter(e -> !e.isSystemGenerated()).collect(Collectors.toList());
        ArrayList<QueueDetail> withoutConcurrency = new ArrayList<QueueDetail>();
        for (QueueDetail queueDetail : queueDetails) {
            if (queueDetail.getConcurrency().getMin() > 0) {
                this.createExecutor(queueDetail);
                continue;
            }
            withoutConcurrency.add(queueDetail);
        }
        return this.createNonConcurrencyBasedExecutor(withoutConcurrency, queueDetails.size());
    }

    private AsyncTaskExecutor createTaskExecutor(QueueDetail queueDetail, int corePoolSize, int maxPoolSize, int queueCapacity) {
        String name = ThreadUtils.getWorkerName(queueDetail.getName());
        return ThreadUtils.createTaskExecutor(name, name + "-", corePoolSize, maxPoolSize, queueCapacity);
    }

    private List<QueueDetail> getQueueDetail(String queue, MappingInformation mappingInformation) {
        int numRetry = mappingInformation.getNumRetry();
        if (!mappingInformation.getDeadLetterQueueName().isEmpty() && numRetry == -1) {
            log.warn("Dead letter queue {} is set but retry is not set", (Object)mappingInformation.getDeadLetterQueueName());
            numRetry = 3;
        } else if (numRetry == -1) {
            numRetry = Integer.MAX_VALUE;
        }
        String priorityGroup = mappingInformation.getPriorityGroup();
        Map<String, Integer> priority = mappingInformation.getPriority();
        if (StringUtils.isEmpty(priorityGroup) && priority.size() == 1) {
            priorityGroup = "\ud83d\udcaf";
        }
        RqueueConfig rqueueConfig = this.rqueueBeanProvider.getRqueueConfig();
        QueueDetail queueDetail = QueueDetail.builder().name(queue).queueName(rqueueConfig.getQueueName(queue)).processingQueueName(rqueueConfig.getProcessingQueueName(queue)).delayedQueueName(rqueueConfig.getDelayedQueueName(queue)).processingQueueChannelName(rqueueConfig.getProcessingQueueChannelName(queue)).delayedQueueChannelName(rqueueConfig.getDelayedQueueChannelName(queue)).deadLetterQueueName(mappingInformation.getDeadLetterQueueName()).visibilityTimeout(mappingInformation.getVisibilityTimeout()).deadLetterConsumerEnabled(mappingInformation.isDeadLetterConsumerEnabled()).concurrency(mappingInformation.getConcurrency()).batchSize(mappingInformation.getBatchSize()).active(mappingInformation.isActive()).numRetry(numRetry).priority(priority).priorityGroup(priorityGroup).build();
        if (queueDetail.getPriority().size() <= 1) {
            return Collections.singletonList(queueDetail);
        }
        return queueDetail.expandQueueDetail(rqueueConfig.isAddDefaultQueueWithQueueLevelPriority(), rqueueConfig.getDefaultQueueWithQueueLevelPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        log.info("Starting Rqueue Message container");
        Object object = this.lifecycleMgr;
        synchronized (object) {
            this.running = true;
            this.doStart();
            this.rqueueBeanProvider.getApplicationEventPublisher().publishEvent((ApplicationEvent)new RqueueBootstrapEvent(EVENT_SOURCE, true));
            this.lifecycleMgr.notifyAll();
        }
    }

    protected void doStart() {
        RqueueConfig rqueueConfig = this.rqueueBeanProvider.getRqueueConfig();
        if (rqueueConfig.isProducer()) {
            log.info("Producer mode nothing to do...");
            return;
        }
        HashMap<String, List> queueGroupToDetails = new HashMap<String, List>();
        for (QueueDetail queueDetail : EndpointRegistry.getActiveQueueDetails()) {
            int prioritySize = queueDetail.getPriority().size();
            if (prioritySize == 0) {
                this.startQueue(queueDetail.getName(), queueDetail);
                continue;
            }
            List queueDetails = queueGroupToDetails.getOrDefault(queueDetail.getPriorityGroup(), new ArrayList());
            queueDetails.add(queueDetail);
            queueGroupToDetails.put(queueDetail.getPriorityGroup(), queueDetails);
        }
        for (Map.Entry entry : queueGroupToDetails.entrySet()) {
            this.startGroup((String)entry.getKey(), (List)entry.getValue());
        }
    }

    private Map<String, QueueThreadPool> getQueueThreadMap(String groupName, List<QueueDetail> queueDetails) {
        QueueThreadPool queueThreadPool = this.queueThreadMap.get(groupName);
        if (queueThreadPool != null) {
            return queueDetails.stream().collect(Collectors.toMap(QueueDetail::getName, e -> queueThreadPool));
        }
        return queueDetails.stream().collect(Collectors.toMap(QueueDetail::getName, e -> this.queueThreadMap.get(e.getName())));
    }

    protected void startGroup(String groupName, List<QueueDetail> queueDetails) {
        if (this.getPriorityMode() == null) {
            throw new IllegalStateException("Priority mode is not set");
        }
        for (QueueDetail queueDetail : queueDetails) {
            this.queueRunningState.put(queueDetail.getName(), true);
        }
        this.rqueueBeanProvider.getRqueueSystemConfigDao().getConfigByNames(queueDetails.stream().map(QueueDetail::getName).collect(Collectors.toList())).forEach(this.queueStateMgr::pauseQueueIfRequired);
        Map<String, QueueThreadPool> queueThread = this.getQueueThreadMap(groupName, queueDetails);
        Future future = this.getPriorityMode() == PriorityMode.STRICT ? this.taskExecutor.submit((Runnable)new StrictPriorityPoller(StringUtils.groupName(groupName), queueDetails, queueThread, this.rqueueBeanProvider, this.queueStateMgr, this.getMiddleWares(), this.pollingInterval, this.backOffTime, this.postProcessingHandler)) : this.taskExecutor.submit((Runnable)new WeightedPriorityPoller(StringUtils.groupName(groupName), queueDetails, queueThread, this.rqueueBeanProvider, this.queueStateMgr, this.getMiddleWares(), this.pollingInterval, this.backOffTime, this.postProcessingHandler));
        this.scheduledFutureByQueue.put(groupName, future);
    }

    protected void startQueue(String queueName, QueueDetail queueDetail) {
        if (Boolean.TRUE.equals(this.queueRunningState.get(queueName))) {
            return;
        }
        this.queueRunningState.put(queueName, true);
        QueueConfig config = this.rqueueBeanProvider.getRqueueSystemConfigDao().getConfigByName(queueName);
        this.queueStateMgr.pauseQueueIfRequired(config);
        QueueThreadPool queueThreadPool = this.queueThreadMap.get(queueName);
        DefaultRqueuePoller messagePoller = new DefaultRqueuePoller(queueDetail, queueThreadPool, this.rqueueBeanProvider, this.queueStateMgr, this.getMiddleWares(), this.pollingInterval, this.backOffTime, this.postProcessingHandler);
        Future future = this.getTaskExecutor().submit((Runnable)messagePoller);
        this.scheduledFutureByQueue.put(queueName, future);
    }

    public void pauseUnpauseQueue(String queue, boolean pause) {
        this.queueStateMgr.pauseUnpauseQueue(queue, pause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        log.info("Stopping Rqueue Message container");
        Object object = this.lifecycleMgr;
        synchronized (object) {
            this.running = false;
            this.rqueueBeanProvider.getApplicationEventPublisher().publishEvent((ApplicationEvent)new RqueueBootstrapEvent(EVENT_SOURCE, false));
            this.doStop();
            this.lifecycleMgr.notifyAll();
        }
    }

    public AsyncTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected void doStop() {
        RqueueConfig rqueueConfig = this.rqueueBeanProvider.getRqueueConfig();
        if (rqueueConfig.isProducer()) {
            log.info("Producer mode nothing to do...");
            return;
        }
        for (Map.Entry<String, Boolean> runningStateByQueue : this.queueRunningState.entrySet()) {
            if (!Boolean.TRUE.equals(runningStateByQueue.getValue())) continue;
            this.stopQueue(runningStateByQueue.getKey());
        }
        this.waitForRunningQueuesToStop();
    }

    private void waitForRunningQueuesToStop() {
        for (Map.Entry<String, Boolean> entry : this.queueRunningState.entrySet()) {
            String queueName = entry.getKey();
            Future<?> queueSpinningThread = this.scheduledFutureByQueue.get(queueName);
            ThreadUtils.waitForTermination(log, queueSpinningThread, this.getMaxWorkerWaitTime(), "An exception occurred while stopping queue '{}'", queueName);
        }
        if (!ThreadUtils.waitForWorkerTermination(this.queueThreadMap.values(), this.getMaxWorkerWaitTime())) {
            log.error("Some workers are not stopped within time");
        }
    }

    private void stopQueue(String queueName) {
        Assert.isTrue((boolean)this.queueRunningState.containsKey(queueName), (String)("Queue with name '" + queueName + "' does not exist"));
        this.queueRunningState.put(queueName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMgr;
        synchronized (object) {
            return this.running;
        }
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public MessageProcessor getDiscardMessageProcessor() {
        return this.discardMessageProcessor;
    }

    public void setDiscardMessageProcessor(MessageProcessor discardMessageProcessor) {
        Assert.notNull((Object)discardMessageProcessor, (String)"discardMessageProcessor cannot be null");
        this.discardMessageProcessor = discardMessageProcessor;
    }

    public MessageProcessor getDeadLetterQueueMessageProcessor() {
        return this.deadLetterQueueMessageProcessor;
    }

    public void setDeadLetterQueueMessageProcessor(MessageProcessor deadLetterQueueMessageProcessor) {
        Assert.notNull((Object)deadLetterQueueMessageProcessor, (String)"deadLetterQueueMessageProcessor cannot be null");
        this.deadLetterQueueMessageProcessor = deadLetterQueueMessageProcessor;
    }

    public MessageProcessor getManualDeletionMessageProcessor() {
        return this.manualDeletionMessageProcessor;
    }

    public void setManualDeletionMessageProcessor(MessageProcessor manualDeletionMessageProcessor) {
        Assert.notNull((Object)manualDeletionMessageProcessor, (String)"manualDeletionMessageProcessor cannot be null");
        this.manualDeletionMessageProcessor = manualDeletionMessageProcessor;
    }

    public MessageProcessor getPostExecutionMessageProcessor() {
        return this.postExecutionMessageProcessor;
    }

    public void setPostExecutionMessageProcessor(MessageProcessor postExecutionMessageProcessor) {
        Assert.notNull((Object)postExecutionMessageProcessor, (String)"postExecutionMessageProcessor cannot be null");
        this.postExecutionMessageProcessor = postExecutionMessageProcessor;
    }

    public MessageProcessor getPreExecutionMessageProcessor() {
        return this.preExecutionMessageProcessor;
    }

    public void setPreExecutionMessageProcessor(MessageProcessor preExecutionMessageProcessor) {
        Assert.notNull((Object)preExecutionMessageProcessor, (String)"preExecutionMessageProcessor cannot be null");
        this.preExecutionMessageProcessor = preExecutionMessageProcessor;
    }

    public TaskExecutionBackOff getTaskExecutionBackOff() {
        return this.taskExecutionBackOff;
    }

    public void setTaskExecutionBackOff(TaskExecutionBackOff taskExecutionBackOff) {
        Assert.notNull((Object)taskExecutionBackOff, (String)"taskExecutionBackOff cannot be null");
        this.taskExecutionBackOff = taskExecutionBackOff;
    }

    public PriorityMode getPriorityMode() {
        return this.priorityMode;
    }

    public void setPriorityMode(PriorityMode priorityMode) {
        this.priorityMode = priorityMode;
    }

    public void setMiddlewares(List<Middleware> middlewares) {
        Assert.notEmpty(middlewares, (String)"middlewares cannot be null");
        this.middlewares = middlewares;
    }

    public List<Middleware> getMiddleWares() {
        return this.middlewares;
    }

    class QueueStateMgr {
        Set<String> pausedQueues = ConcurrentHashMap.newKeySet();

        QueueStateMgr() {
        }

        boolean isQueueActive(String queueName) {
            return RqueueMessageListenerContainer.this.queueRunningState.getOrDefault(queueName, false);
        }

        boolean isQueuePaused(String queueName) {
            return this.pausedQueues.contains(queueName);
        }

        void pauseUnpauseQueue(String queue, boolean pause) {
            if (pause && this.pausedQueues.contains(queue)) {
                log.error("Duplicate pause called {}", (Object)queue);
                return;
            }
            if (!pause && !this.pausedQueues.contains(queue)) {
                log.error("Queue is not paused but unpause is requested {}", (Object)queue);
                return;
            }
            if (pause) {
                this.pause(queue);
            } else {
                this.unpause(queue);
            }
            RqueueQueuePauseEvent event = new RqueueQueuePauseEvent(RqueueMessageListenerContainer.EVENT_SOURCE, queue, pause);
            RqueueMessageListenerContainer.this.rqueueBeanProvider.getApplicationEventPublisher().publishEvent((ApplicationEvent)event);
        }

        private void unpause(String queue) {
            log.info("Queue '{}' action unpause", (Object)queue);
            this.pausedQueues.remove(queue);
        }

        private void pause(String queue) {
            log.info("Queue '{}' action pause", (Object)queue);
            this.pausedQueues.add(queue);
        }

        void pauseQueueIfRequired(QueueConfig config) {
            if (config == null) {
                return;
            }
            if (config.isPaused()) {
                this.pause(config.getName());
            }
        }
    }
}

